"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmIntegrationPackageStatus = ApmIntegrationPackageStatus;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_diagnostics = require("../context/use_diagnostics");
var _tab_status = require("./tab_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/diagnostics/summary_tab/apm_integration_package_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ApmIntegrationPackageStatus() {
  const {
    diagnosticsBundle,
    status,
    isImported
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    basePath
  } = core.http;
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const isInstalled = diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.fleetPackageInfo.isInstalled;
  const packageVersion = diagnosticsBundle === null || diagnosticsBundle === void 0 ? void 0 : diagnosticsBundle.fleetPackageInfo.version;
  return /*#__PURE__*/_react.default.createElement(_tab_status.TabStatus, {
    isLoading: isLoading,
    isOk: isInstalled,
    "data-test-subj": "integrationPackageStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, isLoading ? '...' : isInstalled ? `APM integration (${packageVersion})` : 'APM integration: not installed', !isImported ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmApmIntegrationPackageStatusGoToApmIntegrationLink",
    href: basePath.prepend('/app/integrations/detail/apm/overview'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }, "Go to APM Integration") : null);
}