"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateInternalRuleTypesByQuery = exports.validateInternalRuleTypesBulkOperation = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateInternalRuleTypesByQuery = async ({
  req,
  ruleTypes,
  rulesClient,
  operationText
}) => {
  const {
    filter,
    ids
  } = req;
  if (!filter && (!ids || ids.length === 0)) {
    return;
  }
  const ruleTypesByQuery = await rulesClient.getRuleTypesByQuery({
    filter,
    ids
  });
  const ruleTypeIds = new Set(ruleTypesByQuery.ruleTypes);
  const notFoundRuleTypeIds = new Set();
  const internalRuleTypeIds = new Set();
  const constructMessage = idsToFormat => Array.from(idsToFormat).join(', ');
  for (const ruleTypeId of ruleTypeIds) {
    const ruleType = ruleTypes.get(ruleTypeId);
    if (!ruleType) {
      notFoundRuleTypeIds.add(ruleTypeId);
    }
    if (ruleType !== null && ruleType !== void 0 && ruleType.internallyManaged) {
      internalRuleTypeIds.add(ruleTypeId);
    }
  }
  if (notFoundRuleTypeIds.size) {
    throw _boom.default.badRequest(`Rule types not found: ${constructMessage(notFoundRuleTypeIds)}`);
  }
  if (internalRuleTypeIds.size) {
    throw _boom.default.badRequest(`Cannot ${operationText} rules of type "${constructMessage(internalRuleTypeIds)}" because they are internally managed.`);
  }
};
exports.validateInternalRuleTypesByQuery = validateInternalRuleTypesByQuery;
const validateInternalRuleTypesBulkOperation = async ({
  ids,
  ruleTypes,
  rulesClient,
  operationText
}) => {
  await validateInternalRuleTypesByQuery({
    req: {
      ids
    },
    ruleTypes,
    rulesClient,
    operationText
  });
};
exports.validateInternalRuleTypesBulkOperation = validateInternalRuleTypesBulkOperation;