"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePickerRangeField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _common = require("@kbn/data-plugin/common");
var _common2 = require("../../../../../common");
var _kibana_react = require("../../../../utils/kibana_react");
var _get_selected_for_date_picker = require("../../helpers/get_selected_for_date_picker");
var i18n = _interopRequireWildcard(require("../../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/alerting/public/pages/maintenance_windows/components/fields/date_picker_range_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DatePickerRangeField = exports.DatePickerRangeField = /*#__PURE__*/_react.default.memo(({
  fields,
  timezone,
  showTimeSelect = true,
  ...rest
}) => {
  const [today] = (0, _react.useState)((0, _moment.default)());
  const systemDateFormat = (0, _kibana_react.useUiSetting)(_common.UI_SETTINGS.DATE_FORMAT, _common2.MAINTENANCE_WINDOW_DATE_FORMAT);
  const {
    setFieldValue
  } = (0, _hook_form_lib.useFormContext)();
  const [form] = (0, _hook_form_lib.useFormData)({
    watch: [fields.startDate.path, fields.endDate.path]
  });
  const {
    selected: startDate,
    utcOffset: startOffset
  } = (0, _get_selected_for_date_picker.getSelectedForDatePicker)(form, fields.startDate.path, timezone);
  const {
    selected: endDate,
    utcOffset: endOffset
  } = (0, _get_selected_for_date_picker.getSelectedForDatePicker)(form, fields.endDate.path, timezone);
  const onStartDateChange = (0, _react.useCallback)(currentDate => {
    if (currentDate && currentDate.isAfter(endDate)) {
      // if the current start date is ahead of the end date
      // set the end date to the current start date + 30 min
      const updatedEndDate = (0, _moment.default)(currentDate).add(30, 'minutes');
      setFieldValue(fields.endDate.path, updatedEndDate);
    }
    // convert the moment date back into a string if it's not null
    setFieldValue(fields.startDate.path, currentDate ? currentDate.toISOString() : currentDate);
  }, [setFieldValue, endDate, fields.endDate.path, fields.startDate.path]);
  const onEndDateChange = (0, _react.useCallback)(currentDate => {
    // convert the moment date back into a string if it's not null
    setFieldValue(fields.endDate.path, currentDate ? currentDate.toISOString() : currentDate);
  }, [setFieldValue, fields.endDate.path]);
  const isInvalid = startDate.isAfter(endDate);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: fields.startDate.label
  }, rest, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
    isInvalid: isInvalid,
    startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      selected: startDate,
      onChange: date => date && onStartDateChange(date),
      startDate: startDate,
      endDate: endDate,
      "aria-label": "Start date",
      showTimeSelect: showTimeSelect,
      minDate: today,
      utcOffset: startOffset,
      dateFormat: systemDateFormat,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 15
      }
    }),
    endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      selected: endDate,
      onChange: date => date && onEndDateChange(date),
      startDate: startDate,
      endDate: endDate,
      "aria-label": "End date",
      showTimeSelect: showTimeSelect,
      minDate: today,
      utcOffset: endOffset,
      dateFormat: systemDateFormat,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 15
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  })), isInvalid ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }, i18n.CREATE_FORM_SCHEDULE_INVALID)) : null);
});
DatePickerRangeField.displayName = 'DatePickerRangeField';