/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class InMemoryClonedSecureSettings {
    public static SecureSettings cloneSecureSettings(Settings source, List<Setting<?>> settingsToClone) throws GeneralSecurityException {
        SecureSettings sourceSecureSettings = Settings.builder().put(source, true).getSecureSettings();
        final HashMap<String, SecureSettingValue> clonedSettings = new HashMap<String, SecureSettingValue>();
        if (sourceSecureSettings != null && settingsToClone != null) {
            for (String settingKey : sourceSecureSettings.getSettingNames()) {
                for (Setting<?> secureSetting : settingsToClone) {
                    if (!secureSetting.match(settingKey)) continue;
                    clonedSettings.put(settingKey, new SecureSettingValue(sourceSecureSettings.getString(settingKey), sourceSecureSettings.getSHA256Digest(settingKey)));
                }
            }
        }
        return new SecureSettings(){

            @Override
            public boolean isLoaded() {
                return true;
            }

            @Override
            public SecureString getString(String setting) {
                SecureSettingValue secureSettingValue = (SecureSettingValue)clonedSettings.get(setting);
                return secureSettingValue != null ? secureSettingValue.value().clone() : null;
            }

            @Override
            public Set<String> getSettingNames() {
                return clonedSettings.keySet();
            }

            @Override
            public InputStream getFile(String setting) {
                throw new UnsupportedOperationException("A cloned SecureSetting cannot be a file");
            }

            @Override
            public byte[] getSHA256Digest(String setting) {
                return ((SecureSettingValue)clonedSettings.get(setting)).sha256Digest();
            }

            @Override
            public void close() {
            }

            @Override
            public void writeTo(StreamOutput out) {
                throw new UnsupportedOperationException("A cloned SecureSetting cannot be serialized");
            }
        };
    }

    private record SecureSettingValue(SecureString value, byte[] sha256Digest) {
    }
}

