/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ProjectId
implements Writeable,
ToXContent {
    private static final String DEFAULT_STRING = "default";
    public static final ProjectId DEFAULT = new ProjectId("default");
    public static final Writeable.Reader<ProjectId> READER = ProjectId::readFrom;
    public static final DiffableUtils.KeySerializer<ProjectId> PROJECT_ID_SERIALIZER = DiffableUtils.getWriteableKeySerializer(READER);
    private static final int MAX_LENGTH = 128;
    private final String id;

    private ProjectId(String id) {
        if (Strings.isNullOrBlank(id)) {
            throw new IllegalArgumentException("project-id cannot be empty");
        }
        if (!ProjectId.isValidFormatId(id)) {
            String message = "project-id [" + id + "] must be alphanumeric ASCII with up to 128 chars";
            assert (false) : message;
            throw new IllegalArgumentException(message);
        }
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public static ProjectId fromId(String id) {
        if (DEFAULT_STRING.equals(id)) {
            return DEFAULT;
        }
        return new ProjectId(id);
    }

    public static boolean isValidFormatId(String id) {
        if (id.length() > 128) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c > '\u007f') {
                return false;
            }
            if (ProjectId.isValidIdChar(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidIdChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '-';
    }

    public static ProjectId readFrom(StreamInput in) throws IOException {
        return ProjectId.fromId(in.readString());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.id);
    }

    public static ProjectId fromXContent(XContentParser parser) throws IOException {
        return ProjectId.fromId(parser.text());
    }

    public static ProjectId ofNullable(@Nullable String id, @Nullable ProjectId fallback) {
        return id == null ? fallback : ProjectId.fromId(id);
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectId projectId = (ProjectId)o;
        return Objects.equals(this.id, projectId.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

