/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopFloatAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopFloatAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("top", ElementType.FLOAT));
    private final DriverContext driverContext;
    private final TopFloatAggregator.SingleState state;
    private final List<Integer> channels;
    private final int limit;
    private final boolean ascending;

    public TopFloatAggregatorFunction(DriverContext driverContext, List<Integer> channels, TopFloatAggregator.SingleState state, int limit, boolean ascending) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.limit = limit;
        this.ascending = ascending;
    }

    public static TopFloatAggregatorFunction create(DriverContext driverContext, List<Integer> channels, int limit, boolean ascending) {
        return new TopFloatAggregatorFunction(driverContext, channels, TopFloatAggregator.initSingle(driverContext.bigArrays(), limit, ascending), limit, ascending);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        FloatBlock vBlock = (FloatBlock)page.getBlock(this.channels.get(0));
        FloatVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock, mask);
            return;
        }
        this.addRawVector(vVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        FloatBlock vBlock = (FloatBlock)page.getBlock(this.channels.get(0));
        FloatVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock);
            return;
        }
        this.addRawVector(vVector);
    }

    private void addRawVector(FloatVector vVector) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            float vValue = vVector.getFloat(valuesPosition);
            TopFloatAggregator.combine(this.state, vValue);
        }
    }

    private void addRawVector(FloatVector vVector, BooleanVector mask) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            float vValue = vVector.getFloat(valuesPosition);
            TopFloatAggregator.combine(this.state, vValue);
        }
    }

    private void addRawBlock(FloatBlock vBlock) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            if (vBlock.isNull(p)) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vBlock.getValueCount(p);
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                float vValue = vBlock.getFloat(vOffset);
                TopFloatAggregator.combine(this.state, vValue);
            }
        }
    }

    private void addRawBlock(FloatBlock vBlock, BooleanVector mask) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || vBlock.isNull(p)) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vBlock.getValueCount(p);
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                float vValue = vBlock.getFloat(vOffset);
                TopFloatAggregator.combine(this.state, vValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + TopFloatAggregatorFunction.intermediateStateDesc().size());
        Object topUncast = page.getBlock(this.channels.get(0));
        if (topUncast.areAllValuesNull()) {
            return;
        }
        FloatBlock top = (FloatBlock)topUncast;
        assert (top.getPositionCount() == 1);
        TopFloatAggregator.combineIntermediate(this.state, top);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = TopFloatAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

