/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;

public class CrossClusterApiKeySigningSettings {
    static final String SETTINGS_PART_SIGNING = "signing";
    static final String SETTINGS_PART_DIAGNOSE_TRUST = "diagnose.trust";
    static final String KEYSTORE_ALIAS_SUFFIX = "keystore.alias";
    static final Setting.AffixSetting<String> SIGNING_KEYSTORE_ALIAS = Setting.affixKeySetting((String)"cluster.remote.", (String)"signing.keystore.alias", key -> Setting.simpleString((String)key, newKey -> {}, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Dynamic}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> SIGNING_KEYSTORE_PATH = Setting.affixKeySetting((String)"cluster.remote.", (String)"signing.keystore.path", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Dynamic}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<SecureString> SIGNING_KEYSTORE_SECURE_PASSWORD = Setting.affixKeySetting((String)"cluster.remote.", (String)"signing.keystore.secure_password", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> SIGNING_KEYSTORE_ALGORITHM = Setting.affixKeySetting((String)"cluster.remote.", (String)"signing.keystore.algorithm", key -> Setting.simpleString((String)key, (String)KeyManagerFactory.getDefaultAlgorithm(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Dynamic}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> SIGNING_KEYSTORE_TYPE = Setting.affixKeySetting((String)"cluster.remote.", (String)"signing.keystore.type", key -> Setting.simpleString((String)key, (String)"", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Dynamic}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<SecureString> SIGNING_KEYSTORE_SECURE_KEY_PASSWORD = Setting.affixKeySetting((String)"cluster.remote.", (String)"signing.keystore.secure_key_password", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> SIGNING_KEY_PATH = Setting.affixKeySetting((String)"cluster.remote.", (String)"signing.key", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Dynamic}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<SecureString> SIGNING_KEY_SECURE_PASSPHRASE = Setting.affixKeySetting((String)"cluster.remote.", (String)"signing.secure_key_passphrase", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> SIGNING_CERT_PATH = Setting.affixKeySetting((String)"cluster.remote.", (String)"signing.certificate", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Dynamic}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting<List<String>> SIGNING_CERTIFICATE_AUTHORITIES = Setting.listSetting((String)"cluster.remote.signing.certificate_authorities", List.of(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Dynamic});
    static final Setting<String> SIGNING_TRUSTSTORE_PATH = Setting.simpleString((String)"cluster.remote.signing.truststore.path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Dynamic});
    static final Setting<SecureString> SIGNING_TRUSTSTORE_SECURE_PASSWORD = SecureSetting.secureString((String)"cluster.remote.signing.truststore.secure_password", null, (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> SIGNING_TRUSTSTORE_ALGORITHM = Setting.simpleString((String)"cluster.remote.signing.truststore.algorithm", (String)KeyManagerFactory.getDefaultAlgorithm(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Dynamic});
    static final Setting<String> SIGNING_TRUSTSTORE_TYPE = Setting.simpleString((String)"cluster.remote.signing.truststore.type", (String)"", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Dynamic});
    static final Setting<Boolean> DIAGNOSE_TRUST_EXCEPTIONS = Setting.boolSetting((String)"cluster.remote.signing.diagnose.trust", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Dynamic});

    public static List<Setting<?>> getDynamicTrustSettings() {
        return List.of(SIGNING_TRUSTSTORE_TYPE, SIGNING_TRUSTSTORE_ALGORITHM, SIGNING_TRUSTSTORE_PATH, SIGNING_CERTIFICATE_AUTHORITIES, DIAGNOSE_TRUST_EXCEPTIONS);
    }

    public static List<Setting.AffixSetting<?>> getDynamicSigningSettings() {
        return List.of(SIGNING_KEYSTORE_ALIAS, SIGNING_KEYSTORE_PATH, SIGNING_KEYSTORE_ALGORITHM, SIGNING_KEYSTORE_TYPE, SIGNING_KEY_PATH, SIGNING_CERT_PATH);
    }

    public static List<Setting<?>> getSecureSettings() {
        return List.of(SIGNING_KEYSTORE_SECURE_PASSWORD, SIGNING_KEYSTORE_SECURE_KEY_PASSWORD, SIGNING_KEY_SECURE_PASSPHRASE, SIGNING_TRUSTSTORE_SECURE_PASSWORD);
    }

    public static List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList(CrossClusterApiKeySigningSettings.getSecureSettings());
        settings.addAll(CrossClusterApiKeySigningSettings.getDynamicSigningSettings());
        settings.addAll(CrossClusterApiKeySigningSettings.getDynamicTrustSettings());
        return settings;
    }
}

