/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CaseInsensitiveMap
implements Map<String, Set<String>> {
    private final HashMap<String, HashSet<String>> internalMap = new HashMap();

    @Nonnull
    protected String normalizeKey(@Nonnull String key) {
        Objects.requireNonNull(key);
        return key.toLowerCase(Locale.ROOT);
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean containsKey(@Nonnull Object key) {
        Objects.requireNonNull(key);
        if (key instanceof String) {
            return this.internalMap.containsKey(this.normalizeKey((String)key));
        }
        return false;
    }

    @Override
    public boolean containsValue(@Nonnull Object value) {
        Objects.requireNonNull(value);
        return this.internalMap.containsValue(value);
    }

    @Override
    @Nonnull
    public Set<String> get(@Nonnull Object key) {
        Objects.requireNonNull(key);
        if (key instanceof String) {
            return this.internalMap.get(this.normalizeKey((String)key));
        }
        return Collections.emptySet();
    }

    @Override
    @Nonnull
    public Set<String> put(@Nonnull String key, @Nonnull Set<String> value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        return this.internalMap.put(this.normalizeKey(key), new HashSet<String>(value));
    }

    @Override
    @Nonnull
    public Set<String> remove(@Nonnull Object key) {
        Objects.requireNonNull(key);
        if (key instanceof String) {
            return this.internalMap.remove(this.normalizeKey((String)key));
        }
        return Collections.emptySet();
    }

    @Override
    public void putAll(@Nullable Map<? extends String, ? extends Set<String>> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<? extends String, ? extends Set<String>> entry : m.entrySet()) {
            String key = entry.getKey();
            Set<String> value = entry.getValue();
            if (key == null || value == null) continue;
            this.internalMap.put(this.normalizeKey(key), new HashSet<String>(value));
        }
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    @Nonnull
    public Set<String> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    @Nonnull
    public Collection<Set<String>> values() {
        return new ArrayList<Set<String>>(this.internalMap.values());
    }

    @Override
    @Nonnull
    public Set<Map.Entry<String, Set<String>>> entrySet() {
        HashSet<Map.Entry<String, Set<String>>> result = new HashSet<Map.Entry<String, Set<String>>>();
        for (final Map.Entry<String, HashSet<String>> entry : this.internalMap.entrySet()) {
            result.add(new Map.Entry<String, Set<String>>(){

                @Override
                public String getKey() {
                    return (String)entry.getKey();
                }

                @Override
                public Set<String> getValue() {
                    return (Set)entry.getValue();
                }

                @Override
                public Set<String> setValue(Set<String> value) {
                    return entry.setValue(new HashSet<String>(value));
                }
            });
        }
        return result;
    }
}

