/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.microsoft.aad.adal4j.AdalAccessTokenResponse;
import com.microsoft.aad.adal4j.AdalAuthorizationGrant;
import com.microsoft.aad.adal4j.AdalClaimsChallengeException;
import com.microsoft.aad.adal4j.AdalErrorCode;
import com.microsoft.aad.adal4j.AdalOAuthRequest;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.StringHelper;
import com.microsoft.aad.adal4j.UserInfo;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

class AdalTokenRequest {
    private final URL uri;
    private final ClientAuthentication clientAuth;
    private final AdalAuthorizationGrant grant;
    private final Map<String, String> headerMap;
    private final Proxy proxy;
    private final SSLSocketFactory sslSocketFactory;

    AdalTokenRequest(URL uri, ClientAuthentication clientAuth, AdalAuthorizationGrant authzGrant, Map<String, String> headerMap, Proxy proxy, SSLSocketFactory sslSocketFactory) {
        this.clientAuth = clientAuth;
        this.grant = authzGrant;
        this.uri = uri;
        this.headerMap = headerMap;
        this.proxy = proxy;
        this.sslSocketFactory = sslSocketFactory;
    }

    AuthenticationResult executeOAuthRequestAndProcessResponse() throws ParseException, AuthenticationException, SerializeException, IOException, java.text.ParseException {
        UserInfo info;
        String refreshToken;
        OIDCTokens tokens;
        AdalAccessTokenResponse response;
        AuthenticationResult result = null;
        HTTPResponse httpResponse = null;
        AdalOAuthRequest adalOAuthHttpRequest = this.toOAuthRequest();
        httpResponse = adalOAuthHttpRequest.send();
        if (httpResponse.getStatusCode() == 200) {
            response = AdalAccessTokenResponse.parseHttpResponse(httpResponse);
            tokens = response.getOIDCTokens();
            refreshToken = null;
            if (tokens.getRefreshToken() != null) {
                refreshToken = tokens.getRefreshToken().getValue();
            }
            info = null;
            if (tokens.getIDToken() != null) {
                info = UserInfo.createFromIdTokenClaims(tokens.getIDToken().getJWTClaimsSet());
            }
        } else {
            TokenErrorResponse errorResponse = TokenErrorResponse.parse((HTTPResponse)httpResponse);
            ErrorObject errorObject = errorResponse.getErrorObject();
            if (AdalErrorCode.AUTHORIZATION_PENDING.toString().equals(errorObject.getCode())) {
                throw new AuthenticationException(AdalErrorCode.AUTHORIZATION_PENDING, errorObject.getDescription());
            }
            if (400 == errorObject.getHTTPStatusCode() && AdalErrorCode.INTERACTION_REQUIRED.toString().equals(errorObject.getCode())) {
                throw new AdalClaimsChallengeException(errorResponse.toJSONObject().toJSONString(), this.getClaims(httpResponse.getContent()));
            }
            throw new AuthenticationException(errorResponse.toJSONObject().toJSONString());
        }
        result = new AuthenticationResult(tokens.getAccessToken().getType().getValue(), tokens.getAccessToken().getValue(), refreshToken, tokens.getAccessToken().getLifetime(), tokens.getIDTokenString(), info, !StringHelper.isBlank(response.getResource()));
        return result;
    }

    private String getClaims(String httpResponseContentStr) {
        JsonElement root = new JsonParser().parse(httpResponseContentStr);
        JsonElement claims = root.getAsJsonObject().get("claims");
        return claims != null ? claims.getAsString() : null;
    }

    AdalOAuthRequest toOAuthRequest() throws SerializeException {
        if (this.uri == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        AdalOAuthRequest httpRequest = new AdalOAuthRequest(HTTPRequest.Method.POST, this.uri, this.headerMap, this.proxy, this.sslSocketFactory);
        httpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        Map<String, List<String>> params = this.grant.toParameters();
        httpRequest.setQuery(URLUtils.serializeParameters(params));
        if (this.clientAuth != null) {
            this.clientAuth.applyTo((HTTPRequest)httpRequest);
        }
        return httpRequest;
    }
}

