/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue.ext;

import co.elastic.logstash.api.Metric;
import java.io.IOException;
import java.util.Objects;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.Event;
import org.logstash.RubyUtil;
import org.logstash.ackedqueue.AckedBatch;
import org.logstash.ackedqueue.Batch;
import org.logstash.ackedqueue.Queue;
import org.logstash.ackedqueue.Settings;
import org.logstash.ackedqueue.SettingsImpl;
import org.logstash.plugins.NamespacedMetricImpl;

@JRubyClass(name={"AckedQueue"})
public final class JRubyAckedQueueExt
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private Queue queue;

    public JRubyAckedQueueExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public Queue getQueue() {
        return this.queue;
    }

    @Deprecated
    public static JRubyAckedQueueExt create(Settings settings) {
        return JRubyAckedQueueExt.create(settings, NamespacedMetricImpl.getNullMetric());
    }

    public static JRubyAckedQueueExt create(Settings settings, Metric metric) {
        JRubyAckedQueueExt queueExt = new JRubyAckedQueueExt(RubyUtil.RUBY, RubyUtil.ACKED_QUEUE_CLASS);
        queueExt.queue = new Queue(settings, metric);
        return queueExt;
    }

    @JRubyMethod(meta=true, name={"file_settings_builder"})
    public static IRubyObject fileSettingsBuilder(ThreadContext context, IRubyObject recv, RubyString path) {
        Settings.Builder settingsBuilder = SettingsImpl.fileSettingsBuilder(path.asJavaString()).elementClass(Event.class);
        return JavaUtil.convertJavaToRuby((Ruby)context.runtime, (Object)settingsBuilder);
    }

    @JRubyMethod(name={"max_unread_events"})
    public IRubyObject ruby_max_unread_events(ThreadContext context) {
        return context.runtime.newFixnum(this.queue.getMaxUnread());
    }

    @JRubyMethod(name={"max_size_in_bytes"})
    public IRubyObject ruby_max_size_in_bytes(ThreadContext context) {
        return context.runtime.newFixnum(this.queue.getMaxBytes());
    }

    @JRubyMethod(name={"page_capacity"})
    public IRubyObject ruby_page_capacity(ThreadContext context) {
        return context.runtime.newFixnum(this.queue.getPageCapacity());
    }

    @JRubyMethod(name={"dir_path"})
    public RubyString ruby_dir_path(ThreadContext context) {
        return context.runtime.newString(this.queue.getDirPath());
    }

    @JRubyMethod(name={"persisted_size_in_bytes"})
    public IRubyObject ruby_persisted_size_in_bytes(ThreadContext context) {
        return context.runtime.newFixnum(this.queue.getPersistedByteSize());
    }

    @JRubyMethod(name={"acked_count"})
    public IRubyObject ruby_acked_count(ThreadContext context) {
        return context.runtime.newFixnum(this.queue.getAckedCount());
    }

    @JRubyMethod(name={"unacked_count"})
    public IRubyObject ruby_unacked_count(ThreadContext context) {
        return context.runtime.newFixnum(this.queue.getUnackedCount());
    }

    @JRubyMethod(name={"unread_count"})
    public IRubyObject ruby_unread_count(ThreadContext context) {
        return context.runtime.newFixnum(this.queue.getUnreadCount());
    }

    public void open() throws IOException {
        this.queue.open();
    }

    public void rubyWrite(ThreadContext context, Event event) {
        try {
            this.queue.write(event);
        }
        catch (IOException e) {
            throw RubyUtil.newRubyIOError(context.runtime, e);
        }
    }

    public void write(Event event) {
        try {
            this.queue.write(event);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unhandleable error occurred while writing to queue.", e);
        }
    }

    @JRubyMethod(name={"read_batch"}, required=2)
    public IRubyObject rubyReadBatch(ThreadContext context, IRubyObject limit, IRubyObject timeout) {
        AckedBatch batch;
        try {
            batch = this.readBatch(RubyFixnum.num2int((IRubyObject)limit), RubyFixnum.num2int((IRubyObject)timeout));
        }
        catch (IOException e) {
            throw RubyUtil.newRubyIOError(context.runtime, e);
        }
        return RubyUtil.toRubyObject(batch);
    }

    public AckedBatch readBatch(int limit, long timeout) throws IOException {
        Batch batch = this.queue.readBatch(limit, timeout);
        return Objects.isNull(batch) ? null : AckedBatch.create(batch);
    }

    @JRubyMethod(name={"is_fully_acked?"})
    public IRubyObject ruby_is_fully_acked(ThreadContext context) {
        return RubyBoolean.newBoolean((Ruby)context.runtime, (boolean)this.queue.isFullyAcked());
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void close() throws IOException {
        this.queue.close();
    }
}

