/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;

public final class TailCallLoop
extends UnaryExpression {
    UserFunction containingFunction;

    public TailCallLoop(UserFunction function) {
        super(function.getBody());
        this.containingFunction = function;
    }

    public UserFunction getContainingFunction() {
        return this.containingFunction;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextInfo);
        return this;
    }

    public int getImplementationMethod() {
        return this.operand.getImplementationMethod();
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public Expression copy() {
        throw new UnsupportedOperationException("TailCallLoop.copy()");
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        UserFunction fn;
        XPathContextMajor cm = (XPathContextMajor)context;
        do {
            SequenceIterator iter = this.operand.iterate(cm);
            GroundedValue extent = SequenceExtent.makeSequenceExtent(iter);
            fn = cm.getTailCallFunction();
            if (fn != null) continue;
            return extent.iterate();
        } while (fn == this.containingFunction);
        return this.tailCallDifferentFunction(fn, cm).iterate();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        UserFunction fn;
        XPathContextMajor cm = (XPathContextMajor)context;
        do {
            Item item = this.operand.evaluateItem(context);
            fn = cm.getTailCallFunction();
            if (fn != null) continue;
            return item;
        } while (fn == this.containingFunction);
        return this.tailCallDifferentFunction(fn, cm).head();
    }

    public void process(XPathContext context) throws XPathException {
        UserFunction fn;
        XPathContextMajor cm = (XPathContextMajor)context;
        do {
            this.operand.process(context);
            fn = cm.getTailCallFunction();
            if (fn != null) continue;
            return;
        } while (fn == this.containingFunction);
        SequenceTool.process(this.tailCallDifferentFunction(fn, cm), cm, this.operand.getLocationId());
    }

    private Sequence tailCallDifferentFunction(UserFunction fn, XPathContextMajor cm) throws XPathException {
        cm.resetStackFrameMap(fn.getStackFrameMap(), fn.getNumberOfArguments());
        cm.setCurrentComponent(fn.getDeclaringComponent());
        try {
            return ExpressionTool.evaluate(fn.getBody(), fn.getEvaluationMode(), cm, 1);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            err.maybeSetContext(cm);
            throw err;
        }
    }

    public ItemType getItemType() {
        return this.operand.getItemType();
    }

    public String getExpressionName() {
        return "tailCallLoop";
    }
}

