/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.drda;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class NaiveTrustManager
implements X509TrustManager {
    public static final String SSL_KEYSTORE = "javax.net.ssl.keyStore";
    public static final String SSL_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static TrustManager[] thisManager = null;

    private NaiveTrustManager() {
    }

    public static SocketFactory getSocketFactory(Properties sslProperties) throws NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        SSLContext ctx;
        if (thisManager == null) {
            thisManager = new TrustManager[]{new NaiveTrustManager()};
        }
        if ((ctx = SSLContext.getInstance("TLS")).getProvider().getName().equals("SunJSSE") && sslProperties.getProperty(SSL_KEYSTORE) != null && sslProperties.getProperty(SSL_KEYSTORE_PASSWORD) != null) {
            String keyStore = sslProperties.getProperty(SSL_KEYSTORE);
            String keyStorePassword = sslProperties.getProperty(SSL_KEYSTORE_PASSWORD);
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(keyStore), keyStorePassword.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
            kmf.init(ks, keyStorePassword.toCharArray());
            ctx.init(kmf.getKeyManagers(), thisManager, null);
        } else {
            ctx.init(null, thisManager, null);
        }
        return ctx.getSocketFactory();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new CertificateException();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

