/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.matchers.source;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.datageneration.matchers.GenericEqualsMatcher;
import org.elasticsearch.datageneration.matchers.MatchResult;
import org.elasticsearch.datageneration.matchers.Messages;
import org.elasticsearch.datageneration.matchers.source.DynamicFieldMatcher;
import org.elasticsearch.datageneration.matchers.source.FieldSpecificMatcher;
import org.elasticsearch.datageneration.matchers.source.MappingTransforms;
import org.elasticsearch.datageneration.matchers.source.SourceTransforms;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class SourceMatcher
extends GenericEqualsMatcher<List<Map<String, Object>>> {
    private final Map<String, Map<String, Object>> mappingLookup;
    private final Map<String, MappingTransforms.FieldMapping> actualNormalizedMapping;
    private final Map<String, MappingTransforms.FieldMapping> expectedNormalizedMapping;
    private final Map<String, FieldSpecificMatcher> fieldSpecificMatchers;
    private final DynamicFieldMatcher dynamicFieldMatcher;

    public SourceMatcher(Map<String, Map<String, Object>> mappingLookup, XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings, List<Map<String, Object>> actual, List<Map<String, Object>> expected, boolean ignoringSort) {
        super(actualMappings, actualSettings, expectedMappings, expectedSettings, actual, expected, ignoringSort);
        this.mappingLookup = mappingLookup;
        Map actualMappingAsMap = (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)actualMappings), (boolean)false, (XContentType)actualMappings.contentType()).v2();
        this.actualNormalizedMapping = MappingTransforms.normalizeMapping(actualMappingAsMap);
        Map expectedMappingAsMap = (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)expectedMappings), (boolean)false, (XContentType)actualMappings.contentType()).v2();
        this.expectedNormalizedMapping = MappingTransforms.normalizeMapping(expectedMappingAsMap);
        this.fieldSpecificMatchers = FieldSpecificMatcher.matchers(actualMappings, actualSettings, expectedMappings, expectedSettings);
        this.dynamicFieldMatcher = new DynamicFieldMatcher(actualMappings, actualSettings, expectedMappings, expectedSettings);
    }

    @Override
    public MatchResult match() {
        if (((List)this.actual).size() != ((List)this.expected).size()) {
            return MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Number of documents does not match, " + Messages.prettyPrintCollections((Collection)this.actual, (Collection)this.expected)));
        }
        List<Map> sortedAndFlattenedActual = ((List)this.actual).stream().map(s -> SourceTransforms.normalize(s, this.mappingLookup)).toList();
        List<Map> sortedAndFlattenedExpected = ((List)this.expected).stream().map(s -> SourceTransforms.normalize(s, this.mappingLookup)).toList();
        for (int i = 0; i < sortedAndFlattenedActual.size(); ++i) {
            Map expected;
            Map actual = sortedAndFlattenedActual.get(i);
            MatchResult result = this.compareSource(actual, expected = sortedAndFlattenedExpected.get(i));
            if (result.isMatch()) continue;
            String message = "Source matching failed at document id [" + i + "]. " + result.getMessage();
            return MatchResult.noMatch(message);
        }
        return MatchResult.match();
    }

    private MatchResult compareSource(Map<String, List<Object>> actual, Map<String, List<Object>> expected) {
        for (Map.Entry<String, List<Object>> expectedFieldEntry : expected.entrySet()) {
            List<Object> expectedValues;
            List<Object> actualValues;
            String name = expectedFieldEntry.getKey();
            MatchResult matchIncludingFieldSpecificMatchers = this.matchWithFieldSpecificMatcher(name, actualValues = actual.get(name), expectedValues = expectedFieldEntry.getValue());
            if (matchIncludingFieldSpecificMatchers.isMatch()) continue;
            String message = "Source documents don't match for field [" + name + "]: " + matchIncludingFieldSpecificMatchers.getMessage();
            return MatchResult.noMatch(message);
        }
        return MatchResult.match();
    }

    private MatchResult matchWithFieldSpecificMatcher(String fieldName, List<Object> actualValues, List<Object> expectedValues) {
        MappingTransforms.FieldMapping actualFieldMapping = this.actualNormalizedMapping.get(fieldName);
        if (actualFieldMapping == null) {
            if (this.expectedNormalizedMapping.get(fieldName) != null && !fieldName.equals("@timestamp") && !fieldName.equals("host.name")) {
                throw new IllegalStateException("Leaf field [" + fieldName + "] is present in expected mapping but absent in actual mapping");
            }
            return this.dynamicFieldMatcher.match(actualValues, expectedValues);
        }
        String actualFieldType = (String)actualFieldMapping.mappingParameters().get("type");
        if (actualFieldType == null) {
            throw new IllegalStateException("Field type is missing from leaf field Leaf field [" + fieldName + "] mapping parameters");
        }
        MappingTransforms.FieldMapping expectedFieldMapping = this.expectedNormalizedMapping.get(fieldName);
        if (expectedFieldMapping == null) {
            throw new IllegalStateException("Leaf field [" + fieldName + "] is present in actual mapping but absent in expected mapping");
        }
        Object expectedFieldType = expectedFieldMapping.mappingParameters().get("type");
        if (!Objects.equals(actualFieldType, expectedFieldType)) {
            throw new IllegalStateException("Leaf field [" + fieldName + "] has type [" + actualFieldType + "] in actual mapping but a different type [" + String.valueOf(expectedFieldType) + "] in expected mapping");
        }
        FieldSpecificMatcher fieldSpecificMatcher = this.fieldSpecificMatchers.get(actualFieldType);
        assert (fieldSpecificMatcher != null) : "Missing matcher for field type [" + actualFieldType + "]";
        return fieldSpecificMatcher.match(actualValues, expectedValues, actualFieldMapping.mappingParameters(), expectedFieldMapping.mappingParameters());
    }
}

