/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.search.lookup.SourceProvider;

class ConcurrentSegmentSourceProvider
implements SourceProvider {
    private final Function<SourceFilter, SourceLoader> sourceLoaderProvider;
    private final SourceLoader sourceLoader;
    private final StoredFieldLoader storedFieldLoader;
    private final Map<Object, Leaf> leaves = ConcurrentCollections.newConcurrentMap();
    private final boolean isStoredSource;

    ConcurrentSegmentSourceProvider(MappingLookup lookup, SourceFilter filter, SourceFieldMetrics metrics) {
        this.sourceLoaderProvider = sourceFilter -> lookup.newSourceLoader((SourceFilter)sourceFilter, metrics);
        this.sourceLoader = this.sourceLoaderProvider.apply(filter);
        this.isStoredSource = !lookup.isSourceSynthetic();
        this.storedFieldLoader = StoredFieldLoader.create(this.isStoredSource, this.sourceLoader.requiredStoredFields(), true);
    }

    private ConcurrentSegmentSourceProvider(ConcurrentSegmentSourceProvider source, SourceFilter filter) {
        assert (!source.isStoredSource);
        this.sourceLoaderProvider = source.sourceLoaderProvider;
        this.isStoredSource = source.isStoredSource;
        this.sourceLoader = source.sourceLoaderProvider.apply(filter);
        this.storedFieldLoader = StoredFieldLoader.create(this.isStoredSource, this.sourceLoader.requiredStoredFields(), true);
    }

    @Override
    public Source getSource(LeafReaderContext ctx, int doc) throws IOException {
        Object id = ctx.id();
        Leaf leaf = this.leaves.get(id);
        if (leaf == null) {
            leaf = new Leaf(this.sourceLoader.leaf(ctx.reader(), null), this.storedFieldLoader.getLoader(ctx, null));
            Leaf existing = this.leaves.put(id, leaf);
            assert (existing == null) : "unexpected source provider [" + String.valueOf(existing) + "]";
        } else if (!this.isStoredSource && doc < leaf.doc) {
            leaf = new Leaf(this.sourceLoader.leaf(ctx.reader(), null), this.storedFieldLoader.getLoader(ctx, null));
            this.leaves.put(id, leaf);
        }
        return leaf.getSource(ctx, doc);
    }

    @Override
    public SourceProvider optimizedSourceProvider(SourceFilter sourceFilter) {
        if (this.isStoredSource) {
            return this;
        }
        return new ConcurrentSegmentSourceProvider(this, sourceFilter);
    }

    private static class Leaf
    implements SourceProvider {
        private final SourceLoader.Leaf sourceLoader;
        private final LeafStoredFieldLoader storedFieldLoader;
        int doc = -1;
        Source source = null;

        private Leaf(SourceLoader.Leaf sourceLoader, LeafStoredFieldLoader storedFieldLoader) {
            this.sourceLoader = sourceLoader;
            this.storedFieldLoader = storedFieldLoader;
        }

        @Override
        public Source getSource(LeafReaderContext ctx, int doc) throws IOException {
            if (this.doc == doc) {
                return this.source;
            }
            this.doc = doc;
            this.storedFieldLoader.advanceTo(doc);
            this.source = this.sourceLoader.source(this.storedFieldLoader, doc);
            return this.source;
        }
    }
}

