/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class InsertFieldExtraction
extends PhysicalOptimizerRules.ParameterizedOptimizerRule<PhysicalPlan, LocalPhysicalOptimizerContext> {
    @Override
    public PhysicalPlan rule(PhysicalPlan plan, LocalPhysicalOptimizerContext context) {
        plan = (PhysicalPlan)plan.transformUp(p -> {
            if (p instanceof LeafExec) {
                return p;
            }
            Set<Attribute> missing = InsertFieldExtraction.missingAttributes(p);
            if (!missing.isEmpty()) {
                ArrayList<PhysicalPlan> newChildren = new ArrayList<PhysicalPlan>(p.children().size());
                boolean found = false;
                for (PhysicalPlan child : p.children()) {
                    if (!found && child.outputSet().stream().anyMatch(EsQueryExec::isSourceAttribute)) {
                        found = true;
                        child = new FieldExtractExec(p.source(), child, List.copyOf(missing), context.configuration().pragmas().fieldExtractPreference());
                    }
                    newChildren.add(child);
                }
                if (!found) {
                    throw new IllegalArgumentException("No child with doc id found");
                }
                return (PhysicalPlan)p.replaceChildren(newChildren);
            }
            return p;
        });
        return plan;
    }

    private static Set<Attribute> missingAttributes(PhysicalPlan p) {
        LinkedHashSet<Attribute> missing = new LinkedHashSet<Attribute>();
        AttributeSet input = p.inputSet();
        p.references().forEach(f -> {
            if ((f instanceof FieldAttribute || f instanceof MetadataAttribute) && !input.contains(f)) {
                missing.add((Attribute)f);
            }
        });
        return missing;
    }
}

