/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Contains;

public final class ContainsEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ContainsEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator substr;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ContainsEvaluator(Source source, EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator substr, DriverContext driverContext) {
        this.source = source;
        this.str = str;
        this.substr = substr;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock strBlock = (BytesRefBlock)this.str.eval(page);){
            BooleanBlock booleanBlock;
            block20: {
                BytesRefVector substrVector;
                BytesRefVector strVector;
                BytesRefBlock substrBlock;
                block18: {
                    BooleanBlock booleanBlock2;
                    block19: {
                        block16: {
                            BooleanBlock booleanBlock3;
                            block17: {
                                substrBlock = (BytesRefBlock)this.substr.eval(page);
                                try {
                                    strVector = strBlock.asVector();
                                    if (strVector != null) break block16;
                                    booleanBlock3 = this.eval(page.getPositionCount(), strBlock, substrBlock);
                                    if (substrBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (substrBlock != null) {
                                        try {
                                            substrBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                substrBlock.close();
                            }
                            return booleanBlock3;
                        }
                        substrVector = substrBlock.asVector();
                        if (substrVector != null) break block18;
                        booleanBlock2 = this.eval(page.getPositionCount(), strBlock, substrBlock);
                        if (substrBlock == null) break block19;
                        substrBlock.close();
                    }
                    return booleanBlock2;
                }
                booleanBlock = this.eval(page.getPositionCount(), strVector, substrVector).asBlock();
                if (substrBlock == null) break block20;
                substrBlock.close();
            }
            return booleanBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.str.baseRamBytesUsed();
        return baseRamBytesUsed += this.substr.baseRamBytesUsed();
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock strBlock, BytesRefBlock substrBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef substrScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (strBlock.getValueCount(p) != 1) {
                    if (strBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (substrBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (substrBlock.getValueCount(p) != 1) {
                    if (substrBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                BytesRef str = strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch);
                BytesRef substr = substrBlock.getBytesRef(substrBlock.getFirstValueIndex(p), substrScratch);
                result.appendBoolean(Contains.process(str, substr));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BytesRefVector strVector, BytesRefVector substrVector) {
        try (BooleanVector.FixedBuilder result = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef substrScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                BytesRef str = strVector.getBytesRef(p, strScratch);
                BytesRef substr = substrVector.getBytesRef(p, substrScratch);
                result.appendBoolean(p, Contains.process(str, substr));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "ContainsEvaluator[str=" + String.valueOf(this.str) + ", substr=" + String.valueOf(this.substr) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.substr});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final EvalOperator.ExpressionEvaluator.Factory substr;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory str, EvalOperator.ExpressionEvaluator.Factory substr) {
            this.source = source;
            this.str = str;
            this.substr = substr;
        }

        public ContainsEvaluator get(DriverContext context) {
            return new ContainsEvaluator(this.source, this.str.get(context), this.substr.get(context), context);
        }

        public String toString() {
            return "ContainsEvaluator[str=" + String.valueOf(this.str) + ", substr=" + String.valueOf(this.substr) + "]";
        }
    }
}

