/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.score;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.score.Decay;

public final class DecayDatetimeEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DecayDatetimeEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator value;
    private final long origin;
    private final long scale;
    private final long offset;
    private final double decay;
    private final Decay.DecayFunction decayFunction;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DecayDatetimeEvaluator(Source source, EvalOperator.ExpressionEvaluator value, long origin, long scale, long offset, double decay, Decay.DecayFunction decayFunction, DriverContext driverContext) {
        this.source = source;
        this.value = value;
        this.origin = origin;
        this.scale = scale;
        this.offset = offset;
        this.decay = decay;
        this.decayFunction = decayFunction;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock valueBlock = (LongBlock)this.value.eval(page);){
            LongVector valueVector = valueBlock.asVector();
            if (valueVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valueBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valueVector);
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.value.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, LongBlock valueBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (valueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valueBlock.getValueCount(p) != 1) {
                    if (valueBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                long value = valueBlock.getLong(valueBlock.getFirstValueIndex(p));
                try {
                    result.appendDouble(Decay.processDatetime(value, this.origin, this.scale, this.offset, this.decay, this.decayFunction));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, LongVector valueVector) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                long value = valueVector.getLong(p);
                try {
                    result.appendDouble(Decay.processDatetime(value, this.origin, this.scale, this.offset, this.decay, this.decayFunction));
                    continue;
                }
                catch (IllegalArgumentException | InvalidArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public String toString() {
        return "DecayDatetimeEvaluator[value=" + String.valueOf(this.value) + ", origin=" + this.origin + ", scale=" + this.scale + ", offset=" + this.offset + ", decay=" + this.decay + ", decayFunction=" + String.valueOf((Object)this.decayFunction) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.value);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory value;
        private final long origin;
        private final long scale;
        private final long offset;
        private final double decay;
        private final Decay.DecayFunction decayFunction;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory value, long origin, long scale, long offset, double decay, Decay.DecayFunction decayFunction) {
            this.source = source;
            this.value = value;
            this.origin = origin;
            this.scale = scale;
            this.offset = offset;
            this.decay = decay;
            this.decayFunction = decayFunction;
        }

        public DecayDatetimeEvaluator get(DriverContext context) {
            return new DecayDatetimeEvaluator(this.source, this.value.get(context), this.origin, this.scale, this.offset, this.decay, this.decayFunction, context);
        }

        public String toString() {
            return "DecayDatetimeEvaluator[value=" + String.valueOf(this.value) + ", origin=" + this.origin + ", scale=" + this.scale + ", offset=" + this.offset + ", decay=" + this.decay + ", decayFunction=" + String.valueOf((Object)this.decayFunction) + "]";
        }
    }
}

