/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopIpAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Top
extends AggregateFunction
implements ToAggregator,
SurrogateExpression,
PostOptimizationVerificationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Top", Top::new);
    private static final String ORDER_ASC = "ASC";
    private static final String ORDER_DESC = "DESC";

    @FunctionInfo(returnType={"boolean", "double", "integer", "long", "date", "ip", "keyword"}, description="Collects the top values for a field. Includes repeated values.", type=FunctionType.AGGREGATE, examples={@Example(file="stats_top", tag="top")})
    public Top(Source source, @Param(name="field", type={"boolean", "double", "integer", "long", "date", "ip", "keyword", "text"}, description="The field to collect the top values for.") Expression field, @Param(name="limit", type={"integer"}, description="The maximum number of values to collect.") Expression limit, @Param(name="order", type={"keyword"}, description="The order to calculate the top values. Either `asc` or `desc`.") Expression order) {
        this(source, field, (Expression)Literal.TRUE, limit, order);
    }

    public Top(Source source, Expression field, Expression filter, Expression limit, Expression order) {
        super(source, field, filter, Arrays.asList(limit, order));
    }

    private Top(StreamInput in) throws IOException {
        super(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    @Override
    public Top withFilter(Expression filter) {
        return new Top(this.source(), this.field(), filter, this.limitField(), this.orderField());
    }

    public String getWriteableName() {
        return Top.ENTRY.name;
    }

    Expression limitField() {
        return this.parameters().get(0);
    }

    Expression orderField() {
        return this.parameters().get(1);
    }

    private Integer limitValue() {
        return Foldables.limitValue(this.limitField(), this.sourceText());
    }

    private boolean orderValue() {
        Literal literal;
        String order;
        Expression expression = this.orderField();
        if (expression instanceof Literal && (ORDER_ASC.equalsIgnoreCase(order = BytesRefs.toString((Object)(literal = (Literal)expression).value())) || ORDER_DESC.equalsIgnoreCase(order))) {
            return order.equalsIgnoreCase(ORDER_ASC);
        }
        throw new EsqlIllegalArgumentException("Order value must be a literal, found: " + String.valueOf(this.orderField()));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution typeResolution = TypeResolutions.isType((Expression)this.field(), dt -> dt == DataType.BOOLEAN || dt == DataType.DATETIME || dt == DataType.IP || DataType.isString((DataType)dt) || dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"boolean", "date", "ip", "string", "numeric except unsigned_long or counter types"}).and(TypeResolutions.isNotNull((Expression)this.limitField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND)).and(TypeResolutions.isType((Expression)this.limitField(), dt -> dt == DataType.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"integer"})).and(TypeResolutions.isNotNull((Expression)this.orderField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD)).and(TypeResolutions.isString((Expression)this.orderField(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD));
        if (typeResolution.unresolved()) {
            return typeResolution;
        }
        Expression.TypeResolution result = this.resolveTypeLimit();
        if (!result.equals(Expression.TypeResolution.TYPE_RESOLVED)) {
            return result;
        }
        result = this.resolveTypeOrder(Foldables.TypeResolutionValidator.forPreOptimizationValidation(this.orderField()));
        if (!result.equals(Expression.TypeResolution.TYPE_RESOLVED)) {
            return result;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    private Expression.TypeResolution resolveTypeLimit() {
        return Foldables.resolveTypeLimit(this.limitField(), this.sourceText(), Foldables.TypeResolutionValidator.forPreOptimizationValidation(this.limitField()));
    }

    private Expression.TypeResolution resolveTypeOrder(Foldables.TypeResolutionValidator validator) {
        Expression order = this.orderField();
        if (order == null) {
            validator.invalid(new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Order must be a valid string in [{}], found [{}]", (Object[])new Object[]{this.sourceText(), order})));
        } else if (order instanceof Literal) {
            Literal literal = (Literal)order;
            if (literal.value() == null) {
                validator.invalid(new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Invalid order value in [{}], expected [{}, {}] but got [{}]", (Object[])new Object[]{this.sourceText(), ORDER_ASC, ORDER_DESC, order})));
            } else {
                String value = BytesRefs.toString((Object)literal.value());
                if (value == null || !value.equalsIgnoreCase(ORDER_ASC) && !value.equalsIgnoreCase(ORDER_DESC)) {
                    validator.invalid(new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Invalid order value in [{}], expected [{}, {}] but got [{}]", (Object[])new Object[]{this.sourceText(), ORDER_ASC, ORDER_DESC, order})));
                }
            }
        } else {
            validator.invalidIfPostValidation(Failure.fail(order, "Order must be a valid string in [{}], found [{}]", new Object[]{this.sourceText(), order}));
        }
        return validator.getResolvedType();
    }

    @Override
    public void postOptimizationVerification(Failures failures) {
        this.postOptimizationVerificationLimit(failures);
        this.postOptimizationVerificationOrder(failures);
    }

    private void postOptimizationVerificationLimit(Failures failures) {
        Foldables.resolveTypeLimit(this.limitField(), this.sourceText(), Foldables.TypeResolutionValidator.forPostOptimizationValidation(this.limitField(), failures));
    }

    private void postOptimizationVerificationOrder(Failures failures) {
        this.resolveTypeOrder(Foldables.TypeResolutionValidator.forPostOptimizationValidation(this.orderField(), failures));
    }

    public DataType dataType() {
        return this.field().dataType().noText();
    }

    protected NodeInfo<Top> info() {
        return NodeInfo.create((Node)this, Top::new, (Object)this.field(), (Object)this.filter(), (Object)this.limitField(), (Object)this.orderField());
    }

    public Top replaceChildren(List<Expression> newChildren) {
        return new Top(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        if (type == DataType.LONG || type == DataType.DATETIME) {
            return new TopLongAggregatorFunctionSupplier(this.limitValue().intValue(), this.orderValue());
        }
        if (type == DataType.INTEGER) {
            return new TopIntAggregatorFunctionSupplier(this.limitValue().intValue(), this.orderValue());
        }
        if (type == DataType.DOUBLE) {
            return new TopDoubleAggregatorFunctionSupplier(this.limitValue().intValue(), this.orderValue());
        }
        if (type == DataType.BOOLEAN) {
            return new TopBooleanAggregatorFunctionSupplier(this.limitValue().intValue(), this.orderValue());
        }
        if (type == DataType.IP) {
            return new TopIpAggregatorFunctionSupplier(this.limitValue().intValue(), this.orderValue());
        }
        if (DataType.isString((DataType)type)) {
            return new TopBytesRefAggregatorFunctionSupplier(this.limitValue().intValue(), this.orderValue());
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        if (this.orderField() instanceof Literal && this.limitField() instanceof Literal && this.limitValue() == 1) {
            if (this.orderValue()) {
                return new Min(s, this.field(), this.filter());
            }
            return new Max(s, this.field(), this.filter());
        }
        return null;
    }
}

