/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.kql.parser;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.rest.RestStatus;

public class KqlParsingException
extends ElasticsearchException {
    private final int line;
    private final int charPositionInLine;

    public KqlParsingException(String message, Exception cause, int line, int charPositionInLine) {
        super(message, (Throwable)cause, new Object[0]);
        this.line = line;
        this.charPositionInLine = charPositionInLine;
    }

    public KqlParsingException(String message, int line, int charPositionInLine, Object ... args) {
        super(message, args);
        this.line = line;
        this.charPositionInLine = charPositionInLine;
    }

    public KqlParsingException(String message, Throwable cause, int line, int charPositionInLine, Object ... args) {
        super(message, cause, args);
        this.line = line;
        this.charPositionInLine = charPositionInLine;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.charPositionInLine + 1;
    }

    public String getErrorMessage() {
        return super.getMessage();
    }

    public String getMessage() {
        return LoggerMessageFormat.format((String)"line {}:{}: {}", (Object[])new Object[]{this.getLineNumber(), this.getColumnNumber(), this.getErrorMessage()});
    }

    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }
}

