/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.streams;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.StreamsMetadata;

public enum StreamType {
    LOGS("logs");

    private final String streamName;

    private StreamType(String streamName) {
        this.streamName = streamName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public boolean streamTypeIsEnabled(ProjectMetadata projectMetadata) {
        StreamsMetadata metadata = projectMetadata.custom("streams", StreamsMetadata.EMPTY);
        switch (this.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
        }
        return metadata.isLogsEnabled();
    }

    public boolean matchesStreamPrefix(String indexName) {
        if (indexName == null) {
            return false;
        }
        return indexName.startsWith(this.streamName + ".");
    }

    public static Set<StreamType> getEnabledStreamTypesForProject(ProjectMetadata projectMetadata) {
        return Arrays.stream(StreamType.values()).filter(t -> t.streamTypeIsEnabled(projectMetadata)).collect(Collectors.toCollection(() -> EnumSet.noneOf(StreamType.class)));
    }
}

