/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

public final class MultiShardTermsEnum {
    private final TermMergeQueue queue;
    private final TermsEnumWithCurrent[] top;
    private int numTop;
    private BytesRef current;
    private Function<Object, Object> termsDecoder;

    private MultiShardTermsEnum(List<ShardTermsEnum> enums) throws IOException {
        this.queue = new TermMergeQueue(enums.size());
        this.top = new TermsEnumWithCurrent[enums.size()];
        this.numTop = 0;
        this.queue.clear();
        for (ShardTermsEnum shardEnum : enums) {
            TermsEnum termsEnum = shardEnum.termsEnum();
            BytesRef term = termsEnum.next();
            if (term == null) continue;
            TermsEnumWithCurrent entry = new TermsEnumWithCurrent();
            entry.current = term;
            entry.termsEnum = termsEnum;
            entry.termsDecoder = shardEnum.termsDecoder();
            this.queue.add(entry);
        }
    }

    public String decodedTerm() {
        return this.termsDecoder.apply(this.current).toString();
    }

    private void pullTop() {
        assert (this.numTop == 0);
        this.numTop = this.queue.fillTop(this.top);
        this.current = this.top[0].current;
        this.termsDecoder = this.top[0].termsDecoder;
    }

    private void pushTop() throws IOException {
        for (int i = 0; i < this.numTop; ++i) {
            TermsEnumWithCurrent termsEnum = (TermsEnumWithCurrent)this.queue.top();
            termsEnum.current = termsEnum.termsEnum.next();
            if (termsEnum.current == null) {
                this.queue.pop();
                continue;
            }
            this.queue.updateTop();
        }
        this.numTop = 0;
    }

    public BytesRef next() throws IOException {
        this.pushTop();
        if (this.queue.size() > 0) {
            this.pullTop();
        } else {
            this.current = null;
        }
        return this.current;
    }

    private static final class TermMergeQueue
    extends PriorityQueue<TermsEnumWithCurrent> {
        final int[] stack;

        TermMergeQueue(int size) {
            super(size);
            this.stack = new int[size];
        }

        protected boolean lessThan(TermsEnumWithCurrent termsA, TermsEnumWithCurrent termsB) {
            return termsA.current.compareTo(termsB.current) < 0;
        }

        int fillTop(TermsEnumWithCurrent[] tops) {
            int size = this.size();
            if (size == 0) {
                return 0;
            }
            tops[0] = (TermsEnumWithCurrent)this.top();
            int numTop = 1;
            this.stack[0] = 1;
            int stackLen = 1;
            while (stackLen != 0) {
                int leftChild;
                int index = this.stack[--stackLen];
                int end = Math.min(size, leftChild + 1);
                for (int child = leftChild = index << 1; child <= end; ++child) {
                    TermsEnumWithCurrent te = this.get(child);
                    if (!te.current.equals((Object)tops[0].current)) continue;
                    tops[numTop++] = te;
                    this.stack[stackLen++] = child;
                }
            }
            return numTop;
        }

        private TermsEnumWithCurrent get(int i) {
            return (TermsEnumWithCurrent)this.getHeapArray()[i];
        }
    }

    private static final class TermsEnumWithCurrent {
        private Function<Object, Object> termsDecoder;
        private TermsEnum termsEnum;
        private BytesRef current;

        private TermsEnumWithCurrent() {
        }
    }

    private record ShardTermsEnum(TermsEnum termsEnum, Function<Object, Object> termsDecoder) {
    }

    public static class Builder {
        private final List<ShardTermsEnum> shardTermsEnums = new ArrayList<ShardTermsEnum>();

        void add(TermsEnum termsEnum, Function<Object, Object> termsDecoder) {
            this.shardTermsEnums.add(new ShardTermsEnum(termsEnum, termsDecoder));
        }

        MultiShardTermsEnum build() throws IOException {
            return new MultiShardTermsEnum(this.shardTermsEnums);
        }

        int size() {
            return this.shardTermsEnums.size();
        }
    }
}

