/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.simulatedlatencyrepo;

import java.util.Map;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesMetrics;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.SnapshotMetrics;
import org.elasticsearch.test.simulatedlatencyrepo.LatencySimulatingBlobStoreRepository;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class LatencySimulatingRepositoryPlugin
extends Plugin
implements RepositoryPlugin {
    public static final String TYPE = "latency-simulating";

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, RepositoriesMetrics repositoriesMetrics, SnapshotMetrics snapshotMetrics) {
        return Map.of(TYPE, (projectId, metadata) -> new LatencySimulatingBlobStoreRepository(projectId, metadata, env, namedXContentRegistry, clusterService, bigArrays, recoverySettings, LatencySimulatingRepositoryPlugin.buildSimulator(metadata.settings())));
    }

    private static Runnable buildSimulator(Settings settings) {
        long sleepyTime = settings.getAsLong("latency", Long.valueOf(0L));
        if (sleepyTime == 0L) {
            return () -> {};
        }
        return () -> {
            try {
                Thread.sleep(sleepyTime);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)"BlobRepository read interrupted!");
            }
        };
    }
}

