/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.MedianAbsoluteDeviationDoubleAggregator;
import org.elasticsearch.compute.aggregation.QuantileStates;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class MedianAbsoluteDeviationDoubleAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("quart", ElementType.BYTES_REF));
    private final DriverContext driverContext;
    private final QuantileStates.SingleState state;
    private final List<Integer> channels;

    public MedianAbsoluteDeviationDoubleAggregatorFunction(DriverContext driverContext, List<Integer> channels, QuantileStates.SingleState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static MedianAbsoluteDeviationDoubleAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new MedianAbsoluteDeviationDoubleAggregatorFunction(driverContext, channels, MedianAbsoluteDeviationDoubleAggregator.initSingle(driverContext));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        DoubleBlock vBlock = (DoubleBlock)page.getBlock(this.channels.get(0));
        DoubleVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock, mask);
            return;
        }
        this.addRawVector(vVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        DoubleBlock vBlock = (DoubleBlock)page.getBlock(this.channels.get(0));
        DoubleVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock);
            return;
        }
        this.addRawVector(vVector);
    }

    private void addRawVector(DoubleVector vVector) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            double vValue = vVector.getDouble(valuesPosition);
            MedianAbsoluteDeviationDoubleAggregator.combine(this.state, vValue);
        }
    }

    private void addRawVector(DoubleVector vVector, BooleanVector mask) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            double vValue = vVector.getDouble(valuesPosition);
            MedianAbsoluteDeviationDoubleAggregator.combine(this.state, vValue);
        }
    }

    private void addRawBlock(DoubleBlock vBlock) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            if (vBlock.isNull(p)) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vBlock.getValueCount(p);
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                double vValue = vBlock.getDouble(vOffset);
                MedianAbsoluteDeviationDoubleAggregator.combine(this.state, vValue);
            }
        }
    }

    private void addRawBlock(DoubleBlock vBlock, BooleanVector mask) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || vBlock.isNull(p)) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vBlock.getValueCount(p);
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                double vValue = vBlock.getDouble(vOffset);
                MedianAbsoluteDeviationDoubleAggregator.combine(this.state, vValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + MedianAbsoluteDeviationDoubleAggregatorFunction.intermediateStateDesc().size());
        Object quartUncast = page.getBlock(this.channels.get(0));
        if (quartUncast.areAllValuesNull()) {
            return;
        }
        BytesRefVector quart = ((BytesRefBlock)quartUncast).asVector();
        assert (quart.getPositionCount() == 1);
        BytesRef scratch = new BytesRef();
        MedianAbsoluteDeviationDoubleAggregator.combineIntermediate(this.state, quart.getBytesRef(0, scratch));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = MedianAbsoluteDeviationDoubleAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

