/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.CountDistinctBytesRefAggregator;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.HllStates;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class CountDistinctBytesRefGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("hll", ElementType.BYTES_REF));
    private final HllStates.GroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;
    private final int precision;

    public CountDistinctBytesRefGroupingAggregatorFunction(List<Integer> channels, HllStates.GroupingState state, DriverContext driverContext, int precision) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
        this.precision = precision;
    }

    public static CountDistinctBytesRefGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext, int precision) {
        return new CountDistinctBytesRefGroupingAggregatorFunction(channels, CountDistinctBytesRefAggregator.initGrouping(driverContext.bigArrays(), precision), driverContext, precision);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final BytesRefBlock vBlock = (BytesRefBlock)page.getBlock(this.channels.get(0));
        final BytesRefVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, vBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    CountDistinctBytesRefGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    CountDistinctBytesRefGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    CountDistinctBytesRefGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                CountDistinctBytesRefGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                CountDistinctBytesRefGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                CountDistinctBytesRefGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, vVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, BytesRefBlock vBlock) {
        BytesRef vScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || vBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int vStart = vBlock.getFirstValueIndex(valuesPosition);
                int vEnd = vStart + vBlock.getValueCount(valuesPosition);
                for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                    BytesRef vValue = vBlock.getBytesRef(vOffset, vScratch);
                    CountDistinctBytesRefAggregator.combine(this.state, groupId, vValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, BytesRefVector vVector) {
        BytesRef vScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                BytesRef vValue = vVector.getBytesRef(valuesPosition, vScratch);
                CountDistinctBytesRefAggregator.combine(this.state, groupId, vValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object hllUncast = page.getBlock(this.channels.get(0));
        if (hllUncast.areAllValuesNull()) {
            return;
        }
        BytesRefVector hll = ((BytesRefBlock)hllUncast).asVector();
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                CountDistinctBytesRefAggregator.combineIntermediate(this.state, groupId, hll.getBytesRef(valuesPosition, scratch));
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, BytesRefBlock vBlock) {
        BytesRef vScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || vBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int vStart = vBlock.getFirstValueIndex(valuesPosition);
                int vEnd = vStart + vBlock.getValueCount(valuesPosition);
                for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                    BytesRef vValue = vBlock.getBytesRef(vOffset, vScratch);
                    CountDistinctBytesRefAggregator.combine(this.state, groupId, vValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, BytesRefVector vVector) {
        BytesRef vScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                BytesRef vValue = vVector.getBytesRef(valuesPosition, vScratch);
                CountDistinctBytesRefAggregator.combine(this.state, groupId, vValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object hllUncast = page.getBlock(this.channels.get(0));
        if (hllUncast.areAllValuesNull()) {
            return;
        }
        BytesRefVector hll = ((BytesRefBlock)hllUncast).asVector();
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                CountDistinctBytesRefAggregator.combineIntermediate(this.state, groupId, hll.getBytesRef(valuesPosition, scratch));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, BytesRefBlock vBlock) {
        BytesRef vScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (vBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            int vStart = vBlock.getFirstValueIndex(valuesPosition);
            int vEnd = vStart + vBlock.getValueCount(valuesPosition);
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                BytesRef vValue = vBlock.getBytesRef(vOffset, vScratch);
                CountDistinctBytesRefAggregator.combine(this.state, groupId, vValue);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, BytesRefVector vVector) {
        BytesRef vScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            int groupId = groups.getInt(groupPosition);
            BytesRef vValue = vVector.getBytesRef(valuesPosition, vScratch);
            CountDistinctBytesRefAggregator.combine(this.state, groupId, vValue);
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object hllUncast = page.getBlock(this.channels.get(0));
        if (hllUncast.areAllValuesNull()) {
            return;
        }
        BytesRefVector hll = ((BytesRefBlock)hllUncast).asVector();
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            CountDistinctBytesRefAggregator.combineIntermediate(this.state, groupId, hll.getBytesRef(valuesPosition, scratch));
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, BytesRefBlock vBlock) {
        if (vBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = CountDistinctBytesRefAggregator.evaluateFinal(this.state, selected, ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

