/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialScaleUtils;

public final class ZeroBucket {
    public static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ZeroBucket.class);
    private final int scale;
    private long index;
    private double realThreshold;
    private final long count;
    private static final ZeroBucket MINIMAL_EMPTY = new ZeroBucket(-4611686018427387903L, -11, 0L);

    private ZeroBucket(double zeroThreshold, long count) {
        assert (zeroThreshold >= 0.0) : "zeroThreshold must not be negative";
        this.index = Long.MAX_VALUE;
        this.scale = 38;
        this.realThreshold = zeroThreshold;
        this.count = count;
    }

    private ZeroBucket(long index, int scale, long count) {
        assert (index >= -4611686018427387903L && index <= 0x3FFFFFFFFFFFFFFFL) : "index must be in range [-4611686018427387903, 4611686018427387903]";
        assert (scale >= -11 && scale <= 38) : "scale must be in range [-11, 38]";
        this.index = index;
        this.scale = scale;
        this.realThreshold = Double.NaN;
        this.count = count;
    }

    private ZeroBucket(ZeroBucket toCopy, long newCount) {
        this.realThreshold = toCopy.realThreshold;
        this.index = toCopy.index;
        this.scale = toCopy.scale;
        this.count = newCount;
    }

    public static ZeroBucket minimalEmpty() {
        return MINIMAL_EMPTY;
    }

    public static ZeroBucket minimalWithCount(long count) {
        if (count == 0L) {
            return MINIMAL_EMPTY;
        }
        return new ZeroBucket(MINIMAL_EMPTY, count);
    }

    public static ZeroBucket create(double zeroThreshold, long count) {
        if (zeroThreshold == 0.0) {
            return ZeroBucket.minimalWithCount(count);
        }
        return new ZeroBucket(zeroThreshold, count);
    }

    public static ZeroBucket create(long index, int scale, long count) {
        if (index == ZeroBucket.MINIMAL_EMPTY.index && scale == ZeroBucket.MINIMAL_EMPTY.scale) {
            return ZeroBucket.minimalWithCount(count);
        }
        return new ZeroBucket(index, scale, count);
    }

    public double zeroThreshold() {
        if (Double.isNaN(this.realThreshold)) {
            this.realThreshold = ExponentialScaleUtils.exponentiallyScaledToDoubleValue(this.index(), this.scale());
        }
        return this.realThreshold;
    }

    public long index() {
        if (this.index == Long.MAX_VALUE) {
            this.index = ExponentialScaleUtils.computeIndex(this.zeroThreshold(), this.scale()) + 1L;
        }
        return this.index;
    }

    public int scale() {
        return this.scale;
    }

    public long count() {
        return this.count;
    }

    public ZeroBucket merge(ZeroBucket other) {
        if (other.count == 0L) {
            return this;
        }
        if (this.count == 0L) {
            return other;
        }
        long totalCount = this.count + other.count;
        if (this.compareZeroThreshold(other) >= 0) {
            return new ZeroBucket(this, totalCount);
        }
        return new ZeroBucket(other, totalCount);
    }

    public ZeroBucket collapseOverlappingBucketsForAll(BucketIterator ... bucketIterators) {
        ZeroBucket previous;
        ZeroBucket current = this;
        do {
            previous = current;
            for (BucketIterator buckets : bucketIterators) {
                current = current.collapseOverlappingBuckets(buckets);
            }
        } while (previous.compareZeroThreshold(current) != 0);
        return current;
    }

    public int compareZeroThreshold(ZeroBucket other) {
        return ExponentialScaleUtils.compareExponentiallyScaledValues(this.index(), this.scale(), other.index(), other.scale());
    }

    public ZeroBucket collapseOverlappingBuckets(BucketIterator buckets) {
        long collapsedCount = 0L;
        long highestCollapsedIndex = 0L;
        while (buckets.hasNext() && ExponentialScaleUtils.compareExponentiallyScaledValues(buckets.peekIndex(), buckets.scale(), this.index(), this.scale()) < 0) {
            highestCollapsedIndex = buckets.peekIndex();
            collapsedCount += buckets.peekCount();
            buckets.advance();
        }
        if (collapsedCount == 0L) {
            return this;
        }
        long newZeroCount = this.count + collapsedCount;
        long collapsedUpperBoundIndex = highestCollapsedIndex + 1L;
        if (ExponentialScaleUtils.compareExponentiallyScaledValues(this.index(), this.scale(), collapsedUpperBoundIndex, buckets.scale()) >= 0) {
            return new ZeroBucket(this, newZeroCount);
        }
        return new ZeroBucket(collapsedUpperBoundIndex, buckets.scale(), newZeroCount);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZeroBucket that = (ZeroBucket)o;
        if (this.count() != that.count()) {
            return false;
        }
        if (Double.compare(this.zeroThreshold(), that.zeroThreshold()) != 0) {
            return false;
        }
        return ExponentialScaleUtils.compareExponentiallyScaledValues(this.index(), this.scale(), that.index(), that.scale()) == 0;
    }

    public int hashCode() {
        int normalizedScale = ExponentialScaleUtils.normalizeScale(this.index(), this.scale);
        int scaleAdjustment = normalizedScale - this.scale;
        long normalizedIndex = ExponentialScaleUtils.adjustScale(this.index(), this.scale, scaleAdjustment);
        int result = normalizedScale;
        result = 31 * result + Long.hashCode(normalizedIndex);
        result = 31 * result + Double.hashCode(this.zeroThreshold());
        result = 31 * result + Long.hashCode(this.count);
        return result;
    }
}

