/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.common.io.SqlStreamInput;
import org.elasticsearch.xpack.sql.common.io.SqlStreamOutput;
import org.elasticsearch.xpack.sql.execution.search.CompositeAggCursor;
import org.elasticsearch.xpack.sql.execution.search.PivotCursor;
import org.elasticsearch.xpack.sql.execution.search.SearchHitCursor;
import org.elasticsearch.xpack.sql.execution.search.extractor.SqlBucketExtractors;
import org.elasticsearch.xpack.sql.execution.search.extractor.SqlHitExtractors;
import org.elasticsearch.xpack.sql.expression.function.scalar.Processors;
import org.elasticsearch.xpack.sql.expression.literal.Literals;
import org.elasticsearch.xpack.sql.plugin.BasicFormatter;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.ListCursor;

public final class Cursors {
    private static final NamedWriteableRegistry WRITEABLE_REGISTRY = new NamedWriteableRegistry(Cursors.getNamedWriteables());
    private static final TransportVersion VERSION = TransportVersion.current();

    private Cursors() {
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "0", in -> Cursor.EMPTY));
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "h", SearchHitCursor::new));
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "c", CompositeAggCursor::new));
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "p", PivotCursor::new));
        entries.add(new NamedWriteableRegistry.Entry(Cursor.class, "l", ListCursor::new));
        entries.addAll(Processors.getNamedWriteables());
        entries.addAll(SqlHitExtractors.getNamedWriteables());
        entries.addAll(SqlBucketExtractors.getNamedWriteables());
        entries.addAll(Literals.getNamedWriteables());
        return entries;
    }

    public static String encodeToString(Cursor info, ZoneId zoneId) {
        return Cursors.encodeToString(info, VERSION, zoneId);
    }

    public static String encodeToString(Cursor info, TransportVersion version, ZoneId zoneId) {
        String string;
        block9: {
            if (info == Cursor.EMPTY) {
                return "";
            }
            SqlStreamOutput output = SqlStreamOutput.create(version, zoneId);
            try {
                output.writeOptionalWriteable(null);
                output.writeNamedWriteable(info);
                output.close();
                string = output.streamAsString();
                if (output == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new SqlIllegalArgumentException("Unexpected failure writing cursor", ex);
                }
            }
            output.close();
        }
        return string;
    }

    public static String attachFormatter(String cursor, BasicFormatter formatter) {
        String string;
        block9: {
            if (Strings.isNullOrEmpty((String)cursor) || formatter == null) {
                return cursor;
            }
            SqlStreamOutput output = SqlStreamOutput.create(VERSION, ZoneOffset.UTC);
            try {
                output.writeOptionalWriteable(formatter);
                output.writeString(cursor);
                output.close();
                string = output.streamAsString();
                if (output == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new SqlIllegalArgumentException("Unexpected failure writing cursor", ex);
                }
            }
            output.close();
        }
        return string;
    }

    public static BasicFormatter decodeFormatter(String base64) {
        BasicFormatter basicFormatter;
        block9: {
            if (base64.isEmpty()) {
                return null;
            }
            SqlStreamInput in = SqlStreamInput.fromString(base64, WRITEABLE_REGISTRY, VERSION);
            try {
                basicFormatter = (BasicFormatter)in.readOptionalWriteable(BasicFormatter::new);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new SqlIllegalArgumentException("Unexpected failure reading cursor", ex);
                }
            }
            in.close();
        }
        return basicFormatter;
    }

    public static Tuple<Cursor, ZoneId> decodeFromStringWithZone(String base64, final NamedWriteableRegistry writeableRegistry) {
        return Cursors.internalDecodeFromStringWithZone(base64, new NamedWriteableRegistry(List.of()){

            public <T> Map<String, Writeable.Reader<?>> getReaders(Class<T> categoryClass) {
                if (writeableRegistry.hasReaders(categoryClass)) {
                    return writeableRegistry.getReaders(categoryClass);
                }
                return WRITEABLE_REGISTRY.getReaders(categoryClass);
            }

            public <T> Writeable.Reader<? extends T> getReader(Class<T> categoryClass, String name) {
                if (writeableRegistry.hasReaders(categoryClass)) {
                    return writeableRegistry.getReader(categoryClass, name);
                }
                return WRITEABLE_REGISTRY.getReader(categoryClass, name);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Tuple<Cursor, ZoneId> internalDecodeFromStringWithZone(String base64, NamedWriteableRegistry writeableRegistry) {
        if (base64.isEmpty()) {
            return new Tuple((Object)Cursor.EMPTY, null);
        }
        try (SqlStreamInput in = SqlStreamInput.fromString(base64, writeableRegistry, VERSION);){
            if (in.readOptionalWriteable(BasicFormatter::new) == null) {
                Cursor cursor = (Cursor)in.readNamedWriteable(Cursor.class);
                Tuple tuple2 = new Tuple((Object)cursor, (Object)in.zoneId());
                return tuple2;
            }
            Tuple<Cursor, ZoneId> tuple = Cursors.internalDecodeFromStringWithZone(in.readString(), writeableRegistry);
            return tuple;
        }
        catch (IOException ex) {
            throw new SqlIllegalArgumentException("Unexpected failure reading cursor", ex);
        }
    }
}

