/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.allocation.decider;

import java.util.function.BooleanSupplier;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;

public class SearchableSnapshotAllocationDecider
extends AllocationDecider {
    static final String NAME = "searchable_snapshots";
    private final BooleanSupplier hasValidLicenseSupplier;

    public SearchableSnapshotAllocationDecider(BooleanSupplier hasValidLicenseSupplier) {
        this.hasValidLicenseSupplier = hasValidLicenseSupplier;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.allowAllocation(allocation.metadata().indexMetadata(shardRouting.index()), allocation);
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        return this.allowAllocation(allocation.metadata().indexMetadata(shardRouting.index()), allocation);
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return this.allowAllocation(indexMetadata, allocation);
    }

    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.allowAllocation(allocation.metadata().getProject().getIndexSafe(shardRouting.index()), allocation);
    }

    private Decision allowAllocation(IndexMetadata indexMetadata, RoutingAllocation allocation) {
        if (indexMetadata.isSearchableSnapshot()) {
            if (this.hasValidLicenseSupplier.getAsBoolean()) {
                return allocation.decision((Decision)Decision.YES, NAME, "valid license for searchable snapshots", new Object[0]);
            }
            return allocation.decision((Decision)Decision.NO, NAME, "invalid license for searchable snapshots", new Object[0]);
        }
        return allocation.decision((Decision)Decision.YES, NAME, "decider only applicable for indices backed by searchable snapshots", new Object[0]);
    }
}

