/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics.event;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.application.analytics.AnalyticsCollection;

@Deprecated
public class AnalyticsEvent
implements Writeable,
ToXContentObject {
    public static final ParseField TIMESTAMP_FIELD = new ParseField("@timestamp", new String[0]);
    public static final ParseField EVENT_FIELD = new ParseField("event", new String[0]);
    public static final ParseField EVENT_ACTION_FIELD = new ParseField("action", new String[0]);
    public static final ParseField DATA_STREAM_FIELD = new ParseField("data_stream", new String[0]);
    public static final ParseField DATA_STREAM_TYPE_FIELD = new ParseField("type", new String[0]);
    public static final ParseField DATA_STREAM_NAMESPACE_FIELD = new ParseField("namespace", new String[0]);
    public static final ParseField DATA_STREAM_DATASET_FIELD = new ParseField("dataset", new String[0]);
    private final String eventCollectionName;
    private final Type eventType;
    private final long eventTime;
    private final BytesReference payload;
    private final XContentType xContentType;

    protected AnalyticsEvent(String eventCollectionName, long eventTime, Type eventType, XContentType xContentType, BytesReference payload) {
        this.eventCollectionName = Strings.requireNonBlank((String)eventCollectionName, (String)"eventCollectionName cannot be null");
        this.eventTime = eventTime;
        this.eventType = eventType;
        this.xContentType = Objects.requireNonNull(xContentType, "xContentType cannot be null");
        this.payload = Objects.requireNonNull(payload, "payload cannot be null");
    }

    public AnalyticsEvent(StreamInput in) throws IOException {
        this(in.readString(), in.readLong(), (Type)in.readEnum(Type.class), (XContentType)in.readEnum(XContentType.class), in.readBytesReference());
    }

    public static Builder builder(Context context) {
        return new Builder(context);
    }

    public String eventCollectionName() {
        return this.eventCollectionName;
    }

    public long eventTime() {
        return this.eventTime;
    }

    public Type eventType() {
        return this.eventType;
    }

    public XContentType xContentType() {
        return this.xContentType;
    }

    public BytesReference payload() {
        return this.payload;
    }

    public Map<String, Object> payloadAsMap() {
        return (Map)XContentHelper.convertToMap((BytesReference)this.payload(), (boolean)true, (XContentType)this.xContentType()).v2();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.eventCollectionName);
        out.writeLong(this.eventTime);
        out.writeEnum((Enum)this.eventType);
        XContentHelper.writeTo((StreamOutput)out, (XContentType)this.xContentType);
        out.writeBytesReference(this.payload);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TIMESTAMP_FIELD.getPreferredName(), this.eventTime());
        builder.startObject(EVENT_FIELD.getPreferredName());
        builder.field(EVENT_ACTION_FIELD.getPreferredName(), (Enum)this.eventType());
        builder.endObject();
        builder.startObject(DATA_STREAM_FIELD.getPreferredName());
        builder.field(DATA_STREAM_TYPE_FIELD.getPreferredName(), "behavioral_analytics");
        builder.field(DATA_STREAM_DATASET_FIELD.getPreferredName(), "events");
        builder.field(DATA_STREAM_NAMESPACE_FIELD.getPreferredName(), this.eventCollectionName());
        builder.endObject();
        builder.mapContents(this.payloadAsMap());
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsEvent that = (AnalyticsEvent)o;
        return this.eventCollectionName.equals(that.eventCollectionName) && this.eventTime == that.eventTime && this.eventType == that.eventType && this.xContentType.equals((Object)that.xContentType) && this.payloadAsMap().equals(that.payloadAsMap());
    }

    public int hashCode() {
        return Objects.hash(this.eventCollectionName, this.eventTime, this.xContentType, this.payloadAsMap());
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static enum Type {
        PAGE_VIEW("page_view"),
        SEARCH("search"),
        SEARCH_CLICK("search_click");

        private final String typeName;

        private Type(String typeName) {
            this.typeName = typeName;
        }

        public String toString() {
            return this.typeName.toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        private final Map<String, Object> payloadBuilder = new HashMap<String, Object>();
        private final Context context;

        private Builder(Context context) {
            this.context = context;
        }

        public AnalyticsEvent build() throws IOException {
            try (XContentBuilder builder = JsonXContent.contentBuilder();){
                BytesReference payload = BytesReference.bytes((XContentBuilder)builder.map(this.payloadBuilder));
                AnalyticsEvent analyticsEvent = new AnalyticsEvent(this.context.eventCollectionName(), this.context.eventTime(), this.context.eventType(), builder.contentType(), payload);
                return analyticsEvent;
            }
        }

        public Builder withField(String fieldName, Object fieldValue) {
            if (Objects.nonNull(fieldValue)) {
                this.payloadBuilder.put(fieldName, fieldValue);
            }
            return this;
        }

        public Builder withField(ParseField field, Object fieldValue) {
            return this.withField(field.getPreferredName(), fieldValue);
        }

        public Builder with(Map<String, Object> values) {
            this.payloadBuilder.putAll(values);
            return this;
        }
    }

    public static interface Context {
        public long eventTime();

        public Type eventType();

        public String eventCollectionName();

        public String userAgent();

        public String clientAddress();

        default public AnalyticsCollection analyticsCollection() {
            return new AnalyticsCollection(this.eventCollectionName());
        }
    }
}

