/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.settings;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class RateLimitSettings
implements Writeable,
ToXContentFragment {
    public static final String FIELD_NAME = "rate_limit";
    public static final String REQUESTS_PER_MINUTE_FIELD = "requests_per_minute";
    public static final RateLimitSettings DISABLED_INSTANCE = new RateLimitSettings(1L, TimeUnit.MINUTES, false);
    private static final TransportVersion INFERENCE_API_DISABLE_EIS_RATE_LIMITING = TransportVersion.fromName((String)"inference_api_disable_eis_rate_limiting");
    private final long requestsPerTimeUnit;
    private final TimeUnit timeUnit;
    private final boolean enabled;

    public static RateLimitSettings of(Map<String, Object> map, RateLimitSettings defaultValue, ValidationException validationException, String serviceName, ConfigurationParseContext context) {
        Map<String, Object> settings = ServiceUtils.removeFromMapOrDefaultEmpty(map, FIELD_NAME);
        Long requestsPerMinute = ServiceUtils.extractOptionalPositiveLong(settings, REQUESTS_PER_MINUTE_FIELD, FIELD_NAME, validationException);
        if (ConfigurationParseContext.isRequestContext(context)) {
            ServiceUtils.throwIfNotEmptyMap(settings, serviceName);
        }
        return requestsPerMinute == null ? defaultValue : new RateLimitSettings(requestsPerMinute);
    }

    public static void rejectRateLimitFieldForRequestContext(Map<String, Object> map, String scope, String service, TaskType taskType, ConfigurationParseContext context, ValidationException validationException) {
        if (ConfigurationParseContext.isRequestContext(context) && map.containsKey(FIELD_NAME)) {
            validationException.addValidationError(Strings.format((String)"[%s] rate limit settings are not permitted for service [%s] and task type [%s]", (Object[])new Object[]{scope, service, taskType.toString()}));
        }
    }

    public static Map<String, SettingsConfiguration> toSettingsConfigurationWithDescription(String description, EnumSet<TaskType> supportedTaskTypes) {
        HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
        configurationMap.put("rate_limit.requests_per_minute", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription(description).setLabel("Rate Limit").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.INTEGER).build());
        return configurationMap;
    }

    public static Map<String, SettingsConfiguration> toSettingsConfiguration(EnumSet<TaskType> supportedTaskTypes) {
        return RateLimitSettings.toSettingsConfigurationWithDescription("Minimize the number of rate limit errors.", supportedTaskTypes);
    }

    public RateLimitSettings(long requestsPerMinute) {
        this(requestsPerMinute, TimeUnit.MINUTES);
    }

    public RateLimitSettings(long requestsPerTimeUnit, TimeUnit timeUnit) {
        this(requestsPerTimeUnit, timeUnit, true);
    }

    RateLimitSettings(long requestsPerTimeUnit, TimeUnit timeUnit, boolean enabled) {
        if (requestsPerTimeUnit <= 0L) {
            throw new IllegalArgumentException("requests per minute must be positive");
        }
        this.requestsPerTimeUnit = requestsPerTimeUnit;
        this.timeUnit = Objects.requireNonNull(timeUnit);
        this.enabled = enabled;
    }

    public RateLimitSettings(StreamInput in) throws IOException {
        this.requestsPerTimeUnit = in.readVLong();
        this.timeUnit = TimeUnit.MINUTES;
        this.enabled = in.getTransportVersion().supports(INFERENCE_API_DISABLE_EIS_RATE_LIMITING) ? in.readBoolean() : true;
    }

    public long requestsPerTimeUnit() {
        return this.requestsPerTimeUnit;
    }

    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.enabled) {
            return builder;
        }
        builder.startObject(FIELD_NAME);
        builder.field(REQUESTS_PER_MINUTE_FIELD, this.requestsPerTimeUnit);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.requestsPerTimeUnit);
        if (out.getTransportVersion().supports(INFERENCE_API_DISABLE_EIS_RATE_LIMITING)) {
            out.writeBoolean(this.enabled);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RateLimitSettings that = (RateLimitSettings)o;
        return Objects.equals(this.requestsPerTimeUnit, that.requestsPerTimeUnit) && Objects.equals((Object)this.timeUnit, (Object)that.timeUnit) && this.enabled == that.enabled;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestsPerTimeUnit, this.timeUnit, this.enabled});
    }
}

