/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ai21.completion;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class Ai21ChatCompletionServiceSettings
extends FilteredXContentObject
implements ServiceSettings {
    public static final String NAME = "ai21_completions_service_settings";
    private final String modelId;
    private final RateLimitSettings rateLimitSettings;
    protected static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(200L);
    private static final TransportVersion ML_INFERENCE_AI21_COMPLETION_ADDED = TransportVersion.fromName((String)"ml_inference_ai21_completion_added");

    public static Ai21ChatCompletionServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String model = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "ai21", context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new Ai21ChatCompletionServiceSettings(model, rateLimitSettings);
    }

    public Ai21ChatCompletionServiceSettings(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    public Ai21ChatCompletionServiceSettings(String modelId, @Nullable RateLimitSettings rateLimitSettings) {
        this.modelId = modelId;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return ML_INFERENCE_AI21_COMPLETION_ADDED;
    }

    public String modelId() {
        return this.modelId;
    }

    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        this.rateLimitSettings.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("model_id", this.modelId);
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ai21ChatCompletionServiceSettings that = (Ai21ChatCompletionServiceSettings)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.rateLimitSettings);
    }
}

