/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ImageCriterionRequest;
import software.amazon.awssdk.services.ec2.model.ImageCriterionRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplaceImageCriteriaInAllowedImagesSettingsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ReplaceImageCriteriaInAllowedImagesSettingsRequest> {
    private static final SdkField<List<ImageCriterionRequest>> IMAGE_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageCriteria").getter(ReplaceImageCriteriaInAllowedImagesSettingsRequest.getter(ReplaceImageCriteriaInAllowedImagesSettingsRequest::imageCriteria)).setter(ReplaceImageCriteriaInAllowedImagesSettingsRequest.setter(Builder::imageCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageCriterion").unmarshallLocationName("ImageCriterion").build(), ListTrait.builder().memberLocationName("ImageCriterion").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageCriterionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageCriterion").unmarshallLocationName("ImageCriterion").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ReplaceImageCriteriaInAllowedImagesSettingsRequest.getter(ReplaceImageCriteriaInAllowedImagesSettingsRequest::dryRun)).setter(ReplaceImageCriteriaInAllowedImagesSettingsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_CRITERIA_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplaceImageCriteriaInAllowedImagesSettingsRequest.memberNameToFieldInitializer();
    private final List<ImageCriterionRequest> imageCriteria;
    private final Boolean dryRun;

    private ReplaceImageCriteriaInAllowedImagesSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.imageCriteria = builder.imageCriteria;
        this.dryRun = builder.dryRun;
    }

    public final boolean hasImageCriteria() {
        return this.imageCriteria != null && !(this.imageCriteria instanceof SdkAutoConstructList);
    }

    public final List<ImageCriterionRequest> imageCriteria() {
        return this.imageCriteria;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageCriteria() ? this.imageCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceImageCriteriaInAllowedImagesSettingsRequest)) {
            return false;
        }
        ReplaceImageCriteriaInAllowedImagesSettingsRequest other = (ReplaceImageCriteriaInAllowedImagesSettingsRequest)((Object)obj);
        return this.hasImageCriteria() == other.hasImageCriteria() && Objects.equals(this.imageCriteria(), other.imageCriteria()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"ReplaceImageCriteriaInAllowedImagesSettingsRequest").add("ImageCriteria", this.hasImageCriteria() ? this.imageCriteria() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageCriteria": {
                return Optional.ofNullable(clazz.cast(this.imageCriteria()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageCriterion", IMAGE_CRITERIA_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplaceImageCriteriaInAllowedImagesSettingsRequest, T> g) {
        return obj -> g.apply((ReplaceImageCriteriaInAllowedImagesSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<ImageCriterionRequest> imageCriteria = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceImageCriteriaInAllowedImagesSettingsRequest model) {
            super(model);
            this.imageCriteria(model.imageCriteria);
            this.dryRun(model.dryRun);
        }

        public final List<ImageCriterionRequest.Builder> getImageCriteria() {
            List<ImageCriterionRequest.Builder> result = ImageCriterionRequestListCopier.copyToBuilder(this.imageCriteria);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageCriteria(Collection<ImageCriterionRequest.BuilderImpl> imageCriteria) {
            this.imageCriteria = ImageCriterionRequestListCopier.copyFromBuilder(imageCriteria);
        }

        @Override
        public final Builder imageCriteria(Collection<ImageCriterionRequest> imageCriteria) {
            this.imageCriteria = ImageCriterionRequestListCopier.copy(imageCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageCriteria(ImageCriterionRequest ... imageCriteria) {
            this.imageCriteria(Arrays.asList(imageCriteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageCriteria(Consumer<ImageCriterionRequest.Builder> ... imageCriteria) {
            this.imageCriteria(Stream.of(imageCriteria).map(c -> (ImageCriterionRequest)((ImageCriterionRequest.Builder)ImageCriterionRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplaceImageCriteriaInAllowedImagesSettingsRequest build() {
            return new ReplaceImageCriteriaInAllowedImagesSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReplaceImageCriteriaInAllowedImagesSettingsRequest> {
        public Builder imageCriteria(Collection<ImageCriterionRequest> var1);

        public Builder imageCriteria(ImageCriterionRequest ... var1);

        public Builder imageCriteria(Consumer<ImageCriterionRequest.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

