/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter;

import com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.kafka.formatter.SchemaMessageSerializer;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDeConfig;
import io.confluent.kafka.serializers.subject.SubjectNameStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.ShortSerializer;
import org.apache.kafka.tools.api.RecordReader;

public abstract class SchemaMessageReader<T>
implements RecordReader {
    public static final String VALUE_SCHEMA = "value.schema";
    public static final String KEY_SCHEMA = "key.schema";
    private String topic = null;
    private Boolean parseKey = false;
    private String keySeparator = "\t";
    private boolean parseHeaders = false;
    private String headersDelimiter = "\t";
    private String headersSeparator = ",";
    private Pattern headersSeparatorPattern;
    private String headersKeySeparator = ":";
    private boolean ignoreError = false;
    private String nullMarker = null;
    protected ParsedSchema keySchema = null;
    protected ParsedSchema valueSchema = null;
    private String keySubject = null;
    private String valueSubject = null;
    private SchemaMessageSerializer<T> serializer;

    public SchemaMessageReader() {
    }

    public SchemaMessageReader(String url, ParsedSchema keySchema, ParsedSchema valueSchema, String topic, boolean parseKey, boolean normalizeSchema, boolean autoRegister, boolean useLatest) {
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.topic = topic;
        this.keySubject = topic != null ? topic + "-key" : null;
        this.valueSubject = topic != null ? topic + "-value" : null;
        this.parseKey = parseKey;
        this.serializer = this.createSerializer(null);
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("schema.registry.url", url);
        configs.put("normalize.schemas", normalizeSchema);
        configs.put("auto.register.schemas", autoRegister);
        configs.put("use.latest.version", useLatest);
        this.serializer.configure(configs, false);
    }

    protected abstract SchemaMessageSerializer<T> createSerializer(Serializer var1);

    public void configure(Map<String, ?> configs) {
        Properties props = new Properties();
        props.putAll(configs);
        this.init(props);
    }

    public void init(Properties props) {
        this.topic = props.getProperty("topic");
        if (this.topic == null) {
            throw new ConfigException("Missing topic!");
        }
        if (props.containsKey("parse.key")) {
            this.parseKey = props.getProperty("parse.key").trim().toLowerCase().equals("true");
        }
        if (props.containsKey("key.separator")) {
            this.keySeparator = props.getProperty("key.separator");
        }
        if (props.containsKey("parse.headers")) {
            this.parseHeaders = Boolean.parseBoolean(props.getProperty("parse.headers").trim());
        }
        if (props.containsKey("headers.delimiter")) {
            this.headersDelimiter = props.getProperty("headers.delimiter");
        }
        if (props.containsKey("headers.separator")) {
            this.headersSeparator = props.getProperty("headers.separator");
        }
        this.headersSeparatorPattern = Pattern.compile(this.headersSeparator);
        if (props.containsKey("headers.key.separator")) {
            this.headersKeySeparator = props.getProperty("headers.key.separator");
        }
        if (Objects.equals(this.headersDelimiter, this.headersSeparator)) {
            throw new KafkaException("headers.delimiter and headers.separator may not be equal");
        }
        if (Objects.equals(this.headersDelimiter, this.headersKeySeparator)) {
            throw new KafkaException("headers.delimiter and headers.key.separator may not be equal");
        }
        if (Objects.equals(this.headersSeparator, this.headersKeySeparator)) {
            throw new KafkaException("headers.separator and headers.key.separator may not be equal");
        }
        if (props.containsKey("ignore.error")) {
            this.ignoreError = props.getProperty("ignore.error").trim().toLowerCase().equals("true");
        }
        if (props.containsKey("null.marker")) {
            this.nullMarker = props.getProperty("null.marker");
        }
        if (Objects.equals(this.nullMarker, this.keySeparator)) {
            throw new KafkaException("null.marker and key.separator may not be equal");
        }
        if (Objects.equals(this.nullMarker, this.headersSeparator)) {
            throw new KafkaException("null.marker and headers.separator may not be equal");
        }
        if (Objects.equals(this.nullMarker, this.headersDelimiter)) {
            throw new KafkaException("null.marker and headers.delimiter may not be equal");
        }
        if (Objects.equals(this.nullMarker, this.headersKeySeparator)) {
            throw new KafkaException("null.marker and headers.key.separator may not be equal");
        }
        String url = props.getProperty("schema.registry.url");
        if (url == null) {
            throw new ConfigException("Missing schema registry url!");
        }
        Serializer<?> keySerializer = null;
        if (props.containsKey("key.serializer")) {
            keySerializer = this.getSerializerProperty(true, props, "key.serializer");
        }
        if (this.serializer == null) {
            Map<String, Object> originals = this.getPropertiesMap(props);
            Object autoRegister = props.get("auto.register");
            if (autoRegister != null) {
                originals.put("auto.register.schemas", autoRegister);
            }
            this.serializer = this.createSerializer(keySerializer);
            this.serializer.configure(originals, false);
        }
        AbstractKafkaSchemaSerDeConfig config = new AbstractKafkaSchemaSerDeConfig(AbstractKafkaSchemaSerDeConfig.baseConfigDef(), props, false);
        this.valueSchema = this.getSchema(this.serializer.getSchemaRegistryClient(), props, false);
        Object valueSubjectNameStrategy = config.valueSubjectNameStrategy();
        this.valueSubject = this.getSubjectName(valueSubjectNameStrategy, this.topic, false, this.valueSchema);
        if (this.needsKeySchema()) {
            this.keySchema = this.getSchema(this.serializer.getSchemaRegistryClient(), props, true);
            Object keySubjectNameStrategy = config.keySubjectNameStrategy();
            this.keySubject = this.getSubjectName(keySubjectNameStrategy, this.topic, true, this.keySchema);
        }
    }

    private Serializer<?> getSerializerProperty(boolean isKey, Properties props, String propertyName) {
        try {
            String serializerName = (String)props.get(propertyName);
            Serializer serializer = (Serializer)Class.forName(serializerName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map<String, ?> serializerConfig = this.propertiesWithKeyPrefixStripped(propertyName + ".", props);
            serializer.configure(serializerConfig, isKey);
            return serializer;
        }
        catch (Exception e) {
            throw new ConfigException("Error initializing " + propertyName + ": " + e.getMessage());
        }
    }

    private Map<String, ?> propertiesWithKeyPrefixStripped(String prefix, Properties props) {
        return props.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length()), Map.Entry::getValue));
    }

    private Map<String, Object> getPropertiesMap(Properties props) {
        HashMap<String, Object> originals = new HashMap<String, Object>();
        for (String name : props.stringPropertyNames()) {
            originals.put(name, props.getProperty(name));
        }
        return originals;
    }

    private String getSubjectName(Object subjectNameStrategy, String topic, boolean isKey, ParsedSchema schema) {
        if (subjectNameStrategy instanceof io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy) {
            return ((io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy)subjectNameStrategy).subjectName(topic, isKey, schema);
        }
        throw new RuntimeException("Classes extending deprecated " + SubjectNameStrategy.class.getCanonicalName() + " are not supported. Use classes extending " + io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy.class.getCanonicalName() + " instead.");
    }

    protected ParsedSchema parseSchema(SchemaRegistryClient schemaRegistry, String schema, List<SchemaReference> references) {
        SchemaProvider provider = this.getProvider();
        provider.configure(Collections.singletonMap("schemaVersionFetcher", schemaRegistry));
        return (ParsedSchema)provider.parseSchema(schema, references).get();
    }

    private ParsedSchema getSchema(SchemaRegistryClient schemaRegistry, Properties props, boolean isKey) {
        ParsedSchema schema = this.getSchemaById(schemaRegistry, props, isKey);
        if (schema != null) {
            return schema;
        }
        String schemaString = this.getSchemaString(props, isKey);
        List<SchemaReference> refs = this.getSchemaReferences(props, isKey);
        Metadata metadata = this.getMetadata(props, isKey);
        RuleSet ruleSet = this.getRuleSet(props, isKey);
        return this.parseSchema(schemaRegistry, schemaString, refs).copy(metadata, ruleSet);
    }

    private ParsedSchema getSchemaById(SchemaRegistryClient schemaRegistry, Properties props, boolean isKey) {
        String propKeyId = isKey ? "key.schema.id" : "value.schema.id";
        int schemaId = 0;
        try {
            if (props.containsKey(propKeyId)) {
                schemaId = Integer.parseInt(props.getProperty(propKeyId));
                return schemaRegistry.getSchemaById(schemaId);
            }
            return null;
        }
        catch (NumberFormatException e) {
            throw new SerializationException(String.format("Error parsing %s as int", propKeyId), (Throwable)e);
        }
        catch (RestClientException | IOException e) {
            throw new SerializationException(String.format("Error retrieving schema for id %d", schemaId), e);
        }
    }

    private String getSchemaString(Properties props, boolean isKey) {
        String propKeyFile;
        String propKeyRaw = isKey ? KEY_SCHEMA : VALUE_SCHEMA;
        String string = propKeyFile = isKey ? "key.schema.file" : "value.schema.file";
        if (props.containsKey(propKeyRaw)) {
            return props.getProperty(propKeyRaw);
        }
        if (props.containsKey(propKeyFile)) {
            try {
                return new String(Files.readAllBytes(Paths.get(props.getProperty(propKeyFile), new String[0])), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new ConfigException("Error reading schema from " + props.getProperty(propKeyFile));
            }
        }
        throw new ConfigException("Must provide the " + (isKey ? "key" : "value") + " schema in either " + propKeyRaw + ", " + propKeyRaw + ".id, or " + propKeyFile);
    }

    private List<SchemaReference> getSchemaReferences(Properties props, boolean isKey) {
        String propKey;
        String string = propKey = isKey ? "key.refs" : "value.refs";
        if (props.containsKey(propKey)) {
            try {
                return (List)JacksonMapper.INSTANCE.readValue(props.getProperty(propKey), (TypeReference)new TypeReference<List<SchemaReference>>(){});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptyList();
    }

    private Metadata getMetadata(Properties props, boolean isKey) {
        String propKey;
        String string = propKey = isKey ? "key.metadata" : "value.metadata";
        if (props.containsKey(propKey)) {
            try {
                return (Metadata)JacksonMapper.INSTANCE.readValue(props.getProperty(propKey), Metadata.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private RuleSet getRuleSet(Properties props, boolean isKey) {
        String propKey;
        String string = propKey = isKey ? "key.rule.set" : "value.rule.set";
        if (props.containsKey(propKey)) {
            try {
                return (RuleSet)JacksonMapper.INSTANCE.readValue(props.getProperty(propKey), RuleSet.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private boolean needsKeySchema() {
        return this.parseKey != false && this.serializer.getKeySerializer() == null;
    }

    public Iterator<ProducerRecord<byte[], byte[]>> readRecords(InputStream inputStream) {
        ArrayList<ProducerRecord> records = new ArrayList<ProducerRecord>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                String keyString;
                String headersString = this.parse(this.parseHeaders, line, 0, this.headersDelimiter, "headers delimiter");
                int headersOffset = headersString == null ? 0 : headersString.length() + this.headersDelimiter.length();
                RecordHeaders headers = new RecordHeaders();
                if (headersString != null && !headersString.equals(this.nullMarker)) {
                    this.splitHeaders(headersString, line).forEach(arg_0 -> SchemaMessageReader.lambda$readRecords$2((Headers)headers, arg_0));
                }
                int keyOffset = (keyString = this.parse(this.parseKey, line, headersOffset, this.keySeparator, "key separator")) == null ? 0 : keyString.length() + this.keySeparator.length();
                byte[] serializedKey = null;
                if (keyString != null && !keyString.equals(this.nullMarker)) {
                    if (this.serializer.getKeySerializer() != null) {
                        serializedKey = this.serializeNonSchemaKey((Headers)headers, keyString);
                    } else {
                        T key = this.readFrom(keyString, this.keySchema);
                        serializedKey = this.serializer.serialize(this.keySubject, this.topic, true, (Headers)headers, key, this.keySchema);
                    }
                }
                String valueString = line.substring(headersOffset + keyOffset);
                byte[] serializedValue = null;
                if (valueString != null && !valueString.equals(this.nullMarker)) {
                    T value = this.readFrom(valueString, this.valueSchema);
                    serializedValue = this.serializer.serialize(this.valueSubject, this.topic, false, (Headers)headers, value, this.valueSchema);
                }
                ProducerRecord record = new ProducerRecord(this.topic, null, (Object)serializedKey, serializedValue, (Iterable)headers);
                records.add(record);
            }
        }
        catch (IOException e) {
            throw new KafkaException("Error reading from input", (Throwable)e);
        }
        return records.iterator();
    }

    private String parse(boolean enabled, String line, int startIndex, String demarcation, String demarcationName) {
        if (!enabled) {
            return null;
        }
        int index = line.indexOf(demarcation, startIndex);
        if (index < 0) {
            if (this.ignoreError) {
                return null;
            }
            throw new KafkaException("No " + demarcationName + " found in line " + line);
        }
        return line.substring(startIndex, index);
    }

    private List<Map.Entry<String, byte[]>> splitHeaders(String headers, String line) {
        return Arrays.stream(this.headersSeparatorPattern.split(headers)).map(pair -> {
            int index = pair.indexOf(this.headersKeySeparator);
            if (index < 0) {
                if (this.ignoreError) {
                    return new AbstractMap.SimpleEntry<String, byte[]>((String)pair, null);
                }
                throw new KafkaException("No header key separator found in pair '" + pair + "' in line " + line);
            }
            String headerKey = pair.substring(0, index);
            if (Objects.equals(headerKey, this.nullMarker)) {
                throw new KafkaException("Header keys should not be equal to the null marker '" + this.nullMarker + "' as they can't be null");
            }
            String headerValueString = pair.substring(index + this.headersKeySeparator.length());
            byte[] headerValue = null;
            if (!Objects.equals(headerValueString, this.nullMarker)) {
                headerValue = headerValueString.getBytes(StandardCharsets.UTF_8);
            }
            return new AbstractMap.SimpleEntry<String, byte[]>(headerKey, headerValue);
        }).collect(Collectors.toList());
    }

    private byte[] serializeNonSchemaKey(Headers headers, String keyString) {
        Class<?> serializerClass = this.serializer.getKeySerializer().getClass();
        if (serializerClass == LongSerializer.class) {
            Long longKey = Long.parseLong(keyString);
            return this.serializer.serializeKey(this.topic, headers, longKey);
        }
        if (serializerClass == IntegerSerializer.class) {
            Integer intKey = Integer.parseInt(keyString);
            return this.serializer.serializeKey(this.topic, headers, intKey);
        }
        if (serializerClass == ShortSerializer.class) {
            Short shortKey = Short.parseShort(keyString);
            return this.serializer.serializeKey(this.topic, headers, shortKey);
        }
        return this.serializer.serializeKey(this.topic, headers, keyString);
    }

    protected abstract T readFrom(String var1, ParsedSchema var2);

    public void close() {
        if (this.serializer != null) {
            try {
                this.serializer.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while closing serializer", e);
            }
        }
    }

    protected abstract SchemaProvider getProvider();

    private static /* synthetic */ void lambda$readRecords$2(Headers headers, Map.Entry header) {
        headers.add((String)header.getKey(), (byte[])header.getValue());
    }
}

