/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class XSLGlobalParam
extends XSLGlobalVariable {
    Expression conversion = null;

    protected int getPermittedAttributes() {
        return 2448;
    }

    public XSLGlobalParam() {
        this.sourceBinding.setProperty(4, true);
    }

    public Visibility getVisibility() throws XPathException {
        String statik = this.getAttributeValue("static");
        if (statik == null) {
            return Visibility.PUBLIC;
        }
        try {
            boolean isStatic = this.processBooleanAttribute("static", statik);
            return isStatic ? Visibility.PRIVATE : Visibility.PUBLIC;
        }
        catch (XPathException err) {
            return Visibility.PUBLIC;
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        if (this.sourceBinding.hasProperty(16)) {
            if (this.sourceBinding.getSelectExpression() != null) {
                this.compileError("The select attribute must be absent when required='yes'", "XTSE0010");
            }
            if (this.hasChildNodes()) {
                this.compileError("A parameter specifying required='yes' must have empty content", "XTSE0010");
            }
            Visibility vis = this.getVisibility();
            if (!this.sourceBinding.isStatic() && vis != Visibility.PUBLIC && vis != Visibility.FINAL && vis != Visibility.ABSTRACT) {
                this.compileError("The visibility of a required non-static parameter must be public, final, or abstract", "XTSE3370");
            }
        }
        super.validate(decl);
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        if (this.sourceBinding.isStatic()) {
            super.compileDeclaration(compilation, decl);
        }
        if (!this.redundant) {
            StructuredQName name = this.sourceBinding.getVariableQName();
            this.sourceBinding.handleSequenceConstructor(compilation, decl);
            GlobalParam binding = (GlobalParam)this.compiledVariable;
            binding.setPackageData(this.getCompilation().getPackageData());
            binding.makeDeclaringComponent(Visibility.PUBLIC, this.getContainingPackage());
            Expression select = this.sourceBinding.getSelectExpression();
            if (select != null) {
                select.setContainer(binding);
            }
            binding.setSelectExpression(select);
            binding.setVariableQName(this.sourceBinding.getVariableQName());
            this.initializeBinding(binding);
            binding.setRequiredType(this.getRequiredType());
            binding.setRequiredParam(this.sourceBinding.hasProperty(16));
            binding.setImplicitlyRequiredParam(this.sourceBinding.hasProperty(32));
            this.sourceBinding.fixupBinding(binding);
            this.compiledVariable = binding;
        }
    }

    public SequenceType getRequiredType() {
        SequenceType declaredType = this.sourceBinding.getDeclaredType();
        if (declaredType != null) {
            return declaredType;
        }
        return SequenceType.ANY_SEQUENCE;
    }

    public SymbolicName getSymbolicName() {
        return null;
    }

    public void checkCompatibility(Component component) throws XPathException {
    }
}

