/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.esnative;

import java.util.Set;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;

public class ClientReservedRealm {
    private static final Set<String> RESERVED_USERNAMES = Set.of("elastic", "kibana", "kibana_system", "logstash_system", "beats_system", "apm_system", "remote_monitoring_user");

    public static boolean isReserved(String username, Settings settings) {
        assert (username != null);
        if (ClientReservedRealm.isReservedUsername(username)) {
            return XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings);
        }
        return AnonymousUser.isAnonymousUsername(username, settings);
    }

    public static boolean isReservedUsername(String username) {
        return RESERVED_USERNAMES.contains(username);
    }
}

