/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.http.HttpRouteStats;
import org.elasticsearch.http.HttpRouteStatsTracker;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public final class MethodHandlers {
    private final String path;
    private final Map<RestRequest.Method, Map<RestApiVersion, RestHandler>> methodHandlers;
    private HttpRouteStatsTracker statsTracker;
    private static final VarHandle STATS_TRACKER_HANDLE;

    MethodHandlers(String path) {
        this.path = path;
        this.methodHandlers = new EnumMap<RestRequest.Method, Map<RestApiVersion, RestHandler>>(RestRequest.Method.class);
    }

    public String getPath() {
        return this.path;
    }

    MethodHandlers addMethod(RestRequest.Method method, RestApiVersion version, RestHandler handler) {
        RestHandler existing = this.methodHandlers.computeIfAbsent(method, k -> new EnumMap(RestApiVersion.class)).putIfAbsent(version, handler);
        if (existing != null) {
            throw new IllegalArgumentException("Cannot replace existing handler for [" + this.path + "] for method: " + String.valueOf((Object)method));
        }
        return this;
    }

    RestHandler getHandler(RestRequest.Method method, RestApiVersion version) {
        Map<RestApiVersion, RestHandler> versionToHandlers = this.methodHandlers.get((Object)method);
        if (versionToHandlers == null) {
            return null;
        }
        RestHandler handler = versionToHandlers.get((Object)version);
        return handler == null ? versionToHandlers.get((Object)RestApiVersion.current()) : handler;
    }

    Set<RestRequest.Method> getValidMethods() {
        return this.methodHandlers.keySet();
    }

    public HttpRouteStats getStats() {
        HttpRouteStatsTracker tracker = this.existingStatsTracker();
        if (tracker == null) {
            return HttpRouteStats.EMPTY;
        }
        return tracker.getStats();
    }

    public HttpRouteStatsTracker statsTracker() {
        HttpRouteStatsTracker newTracker;
        HttpRouteStatsTracker tracker = this.existingStatsTracker();
        if (tracker == null && (tracker = STATS_TRACKER_HANDLE.compareAndExchange(this, null, newTracker = new HttpRouteStatsTracker())) == null) {
            tracker = newTracker;
        }
        return tracker;
    }

    private HttpRouteStatsTracker existingStatsTracker() {
        return STATS_TRACKER_HANDLE.getAcquire(this);
    }

    static {
        try {
            STATS_TRACKER_HANDLE = MethodHandles.lookup().findVarHandle(MethodHandlers.class, "statsTracker", HttpRouteStatsTracker.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

