/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.logstashbridge.ingest.PipelineConfigurationBridge;

public class PipelineConfigurationFactory {
    public static final PipelineConfigurationFactory INSTANCE = new PipelineConfigurationFactory();

    public static PipelineConfigurationFactory getInstance() {
        return INSTANCE;
    }

    private PipelineConfigurationFactory() {
    }

    public List<PipelineConfigurationBridge> parseNamedObjects(String json) throws Exception {
        return ((Spec)Spec.MAPPER.readValue(json, Spec.class)).get();
    }

    public PipelineConfigurationBridge parseNamedObject(String json) throws Exception {
        List<PipelineConfigurationBridge> configs = this.parseNamedObjects(json);
        if (configs.isEmpty()) {
            throw new IllegalStateException("Expected a single pipeline definition. Got none");
        }
        if (configs.size() > 1) {
            throw new IllegalStateException("Expected a single pipeline definition. Got " + configs.size());
        }
        return configs.get(0);
    }

    public PipelineConfigurationBridge parseConfigOnly(String pipelineId, String jsonEncodedConfig) {
        return PipelineConfigurationBridge.create(pipelineId, jsonEncodedConfig);
    }

    private static class Spec {
        private static final ObjectMapper MAPPER = new ObjectMapper();
        private final Map<String, String> idToConfigMap = new LinkedHashMap<String, String>();

        private Spec() {
        }

        @JsonAnySetter
        public void setConfig(String pipelineId, JsonNode jsonNode) throws JsonProcessingException {
            this.idToConfigMap.put(pipelineId, MAPPER.writeValueAsString((Object)jsonNode));
        }

        public List<PipelineConfigurationBridge> get() {
            return this.idToConfigMap.entrySet().stream().map(e -> Spec.init((String)e.getKey(), (String)e.getValue())).toList();
        }

        private static PipelineConfigurationBridge init(String id, String json) {
            return PipelineConfigurationBridge.create(id, json);
        }
    }
}

