/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_rules;

import co.elastic.clients.elasticsearch.query_rules.test.QueryRulesetMatchedRule;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class TestResponse
implements JsonpSerializable {
    private final int totalMatchedRules;
    private final List<QueryRulesetMatchedRule> matchedRules;
    public static final JsonpDeserializer<TestResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TestResponse::setupTestResponseDeserializer);

    private TestResponse(Builder builder) {
        this.totalMatchedRules = ApiTypeHelper.requireNonNull(builder.totalMatchedRules, (Object)this, "totalMatchedRules", 0);
        this.matchedRules = ApiTypeHelper.unmodifiableRequired(builder.matchedRules, (Object)this, "matchedRules");
    }

    public static TestResponse of(Function<Builder, ObjectBuilder<TestResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int totalMatchedRules() {
        return this.totalMatchedRules;
    }

    public final List<QueryRulesetMatchedRule> matchedRules() {
        return this.matchedRules;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total_matched_rules");
        generator.write(this.totalMatchedRules);
        if (ApiTypeHelper.isDefined(this.matchedRules)) {
            generator.writeKey("matched_rules");
            generator.writeStartArray();
            for (QueryRulesetMatchedRule item0 : this.matchedRules) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTestResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::totalMatchedRules, JsonpDeserializer.integerDeserializer(), "total_matched_rules");
        op.add(Builder::matchedRules, JsonpDeserializer.arrayDeserializer(QueryRulesetMatchedRule._DESERIALIZER), "matched_rules");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TestResponse> {
        private Integer totalMatchedRules;
        private List<QueryRulesetMatchedRule> matchedRules;

        public final Builder totalMatchedRules(int value) {
            this.totalMatchedRules = value;
            return this;
        }

        public final Builder matchedRules(List<QueryRulesetMatchedRule> list) {
            this.matchedRules = Builder._listAddAll(this.matchedRules, list);
            return this;
        }

        public final Builder matchedRules(QueryRulesetMatchedRule value, QueryRulesetMatchedRule ... values) {
            this.matchedRules = Builder._listAdd(this.matchedRules, value, values);
            return this;
        }

        public final Builder matchedRules(Function<QueryRulesetMatchedRule.Builder, ObjectBuilder<QueryRulesetMatchedRule>> fn) {
            return this.matchedRules(fn.apply(new QueryRulesetMatchedRule.Builder()).build(), new QueryRulesetMatchedRule[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TestResponse build() {
            this._checkSingleUse();
            return new TestResponse(this);
        }
    }
}

