/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.AzureAiStudioServiceSettings;
import co.elastic.clients.elasticsearch.inference.AzureAiStudioServiceType;
import co.elastic.clients.elasticsearch.inference.AzureAiStudioTaskSettings;
import co.elastic.clients.elasticsearch.inference.AzureAiStudioTaskType;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutAzureaistudioResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutAzureaistudioRequest
extends RequestBase
implements JsonpSerializable {
    private final String azureaistudioInferenceId;
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final AzureAiStudioServiceType service;
    private final AzureAiStudioServiceSettings serviceSettings;
    @Nullable
    private final AzureAiStudioTaskSettings taskSettings;
    private final AzureAiStudioTaskType taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutAzureaistudioRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutAzureaistudioRequest::setupPutAzureaistudioRequestDeserializer);
    public static final Endpoint<PutAzureaistudioRequest, PutAzureaistudioResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutAzureaistudioRequest, PutAzureaistudioResponse>("es/inference.put_azureaistudio", request -> "PUT", request -> {
        boolean _azureaistudioInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.azureaistudioInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _azureaistudioInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("azureaistudioInferenceId", request.azureaistudioInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutAzureaistudioResponse._DESERIALIZER);

    private PutAzureaistudioRequest(Builder builder) {
        this.azureaistudioInferenceId = ApiTypeHelper.requireNonNull(builder.azureaistudioInferenceId, this, "azureaistudioInferenceId");
        this.chunkingSettings = builder.chunkingSettings;
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutAzureaistudioRequest of(Function<Builder, ObjectBuilder<PutAzureaistudioRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String azureaistudioInferenceId() {
        return this.azureaistudioInferenceId;
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final AzureAiStudioServiceType service() {
        return this.service;
    }

    public final AzureAiStudioServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final AzureAiStudioTaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final AzureAiStudioTaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    protected static void setupPutAzureaistudioRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, AzureAiStudioServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, AzureAiStudioServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, AzureAiStudioTaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutAzureaistudioRequest> {
        private String azureaistudioInferenceId;
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private AzureAiStudioServiceType service;
        private AzureAiStudioServiceSettings serviceSettings;
        @Nullable
        private AzureAiStudioTaskSettings taskSettings;
        private AzureAiStudioTaskType taskType;
        @Nullable
        private Time timeout;

        public final Builder azureaistudioInferenceId(String value) {
            this.azureaistudioInferenceId = value;
            return this;
        }

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder service(AzureAiStudioServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(AzureAiStudioServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<AzureAiStudioServiceSettings.Builder, ObjectBuilder<AzureAiStudioServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new AzureAiStudioServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable AzureAiStudioTaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<AzureAiStudioTaskSettings.Builder, ObjectBuilder<AzureAiStudioTaskSettings>> fn) {
            return this.taskSettings(fn.apply(new AzureAiStudioTaskSettings.Builder()).build());
        }

        public final Builder taskType(AzureAiStudioTaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutAzureaistudioRequest build() {
            this._checkSingleUse();
            return new PutAzureaistudioRequest(this);
        }
    }
}

