/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TypeCheckingFilter;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.ItemTypeCheckingFunction;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;

public final class ItemChecker
extends UnaryExpression {
    private ItemType requiredItemType;
    private RoleLocator role;

    public ItemChecker(Expression sequence, ItemType itemType, RoleLocator role) {
        super(sequence);
        this.requiredItemType = itemType;
        this.role = role;
        this.adoptChildExpression(sequence);
    }

    public ItemType getRequiredType() {
        return this.requiredItemType;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public RoleLocator getRoleLocator() {
        return this.role;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        if (this.requiredItemType instanceof AnyItemType) {
            return this.operand;
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextInfo);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        int card = this.operand.getCardinality();
        if (card == 8192) {
            return this.operand;
        }
        ItemType supplied = this.operand.getItemType();
        int relation = th.relationship(this.requiredItemType, supplied);
        if (relation == 0 || relation == 1) {
            return this.operand;
        }
        if (relation == 4) {
            if (Cardinality.allowsZero(card)) {
                String message = this.role.composeErrorMessage(this.requiredItemType, this.operand.getItemType());
                visitor.getStaticContext().issueWarning("The only value that can pass type-checking is an empty sequence. " + message, this);
            } else {
                if (this.requiredItemType.equals(BuiltInAtomicType.STRING) && th.isSubType(supplied, BuiltInAtomicType.ANY_URI)) {
                    return this.operand;
                }
                String message = this.role.composeErrorMessage(this.requiredItemType, this.operand.getItemType());
                XPathException err = new XPathException(message);
                err.setErrorCode(this.role.getErrorCode());
                err.setLocator(this);
                err.setIsTypeError(this.role.isTypeError());
                throw err;
            }
        }
        return this;
    }

    public int getImplementationMethod() {
        int m = 22;
        if (!Cardinality.allowsMany(this.getCardinality())) {
            m |= 1;
        }
        return m;
    }

    public IntegerValue[] getIntegerBounds() {
        return this.operand.getIntegerBounds();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        return new ItemMappingIterator(base, this.getMappingFunction(context), true);
    }

    public ItemMappingFunction getMappingFunction(XPathContext context) {
        return new ItemTypeCheckingFunction(this.requiredItemType, this.role, this, context.getConfiguration());
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item = this.operand.evaluateItem(context);
        if (item == null) {
            return null;
        }
        this.testConformance(item, context);
        return item;
    }

    public void process(XPathContext context) throws XPathException {
        Expression next = this.operand;
        int card = 57344;
        if (next instanceof CardinalityChecker) {
            card = ((CardinalityChecker)next).getRequiredCardinality();
            next = ((CardinalityChecker)next).getBaseExpression();
        }
        if ((next.getImplementationMethod() & 4) != 0 && !(this.requiredItemType instanceof DocumentNodeTest)) {
            SequenceReceiver out = context.getReceiver();
            TypeCheckingFilter filter = new TypeCheckingFilter(out);
            filter.setRequiredType(this.requiredItemType, card, this.role, this);
            context.setReceiver(filter);
            next.process(context);
            filter.close();
            context.setReceiver(out);
        } else {
            super.process(context);
        }
    }

    public Expression copy() {
        ItemChecker ic2 = new ItemChecker(this.getBaseExpression().copy(), this.requiredItemType, this.role);
        ExpressionTool.copyLocationInfo(this, ic2);
        return ic2;
    }

    private void testConformance(Item item, XPathContext context) throws XPathException {
        if (!this.requiredItemType.matchesItem(item, true, context == null ? null : context.getConfiguration())) {
            String message;
            if (context == null) {
                message = "Supplied value of type " + Type.displayTypeName(item) + " does not match the required type of " + this.role.getMessage();
            } else {
                NamePool pool = context.getNamePool();
                TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
                message = this.role.composeErrorMessage(this.requiredItemType, Type.getItemType(item, th));
            }
            String errorCode = this.role.getErrorCode();
            if ("XPDY0050".equals(errorCode)) {
                this.dynamicError(message, errorCode, context);
            } else {
                this.typeError(message, errorCode, context);
            }
        }
    }

    public ItemType getItemType() {
        ItemType operandType = this.operand.getItemType();
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        int relationship = th.relationship(this.requiredItemType, operandType);
        switch (relationship) {
            case 3: {
                if (this.requiredItemType instanceof NodeTest && operandType instanceof NodeTest) {
                    return new CombinedNodeTest((NodeTest)this.requiredItemType, 23, (NodeTest)operandType);
                }
                return this.requiredItemType;
            }
            case 0: 
            case 1: {
                return operandType;
            }
        }
        return this.requiredItemType;
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.requiredItemType == ((ItemChecker)other).requiredItemType;
    }

    public int hashCode() {
        return super.hashCode() ^ this.requiredItemType.hashCode();
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("treat");
        out.emitAttribute("as", this.requiredItemType.toString());
        this.operand.explain(out);
        out.endElement();
    }

    public String getExpressionName() {
        return "TreatAs";
    }

    public String toString() {
        String typeDesc = this.requiredItemType.toString();
        return "(" + this.operand.toString() + ") treat as " + typeDesc;
    }

    public String toShortString() {
        return this.operand.toShortString();
    }
}

