/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.PrintWriter;
import java.sql.BatchUpdateException;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLWarning;
import javax.transaction.xa.XAException;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.Utils;

class ExceptionFormatter {
    ExceptionFormatter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printTrace(SqlException e, PrintWriter printWriter, String messageHeader, boolean returnTokensOnly) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            while (e != null) {
                Sqlca sqlca;
                String header = messageHeader + "[SQLException@" + Integer.toHexString(e.hashCode()) + "]";
                printWriter.println(header + " java.sql.SQLException");
                Throwable throwable = e.getCause();
                if (throwable != null) {
                    ExceptionFormatter.printTrace(throwable, printWriter, header);
                }
                if ((sqlca = e.getSqlca()) != null) {
                    ExceptionFormatter.printTrace(sqlca, printWriter, header);
                    sqlca.returnTokensOnlyInMessageText(returnTokensOnly);
                }
                printWriter.println(header + " SQL state  = " + e.getSQLState());
                printWriter.println(header + " Error code = " + String.valueOf(e.getErrorCode()));
                if (e.getSqlca() == null) {
                    printWriter.println(header + " Message    = " + e.getMessage());
                } else {
                    sqlca = e.getSqlca();
                    if (returnTokensOnly) {
                        printWriter.println(header + " Tokens     = " + sqlca.getSqlErrmc());
                    } else {
                        String message = e.getMessage();
                        if (!sqlca.messageTextRetrievedContainsTokensOnly_) {
                            printWriter.println(header + " Message    = " + message);
                        } else {
                            SqlException mysteryException = sqlca.exceptionThrownOnStoredProcInvocation_;
                            if (mysteryException != null && (mysteryException.getErrorCode() == -440 || mysteryException.getErrorCode() == -444)) {
                                printWriter.println(header + " Unable to obtain message text from server. Only message tokens are available. The stored procedure SYSIBM.SQLCAMESSAGE is not installed on server. Contact your DBA.");
                            } else {
                                printWriter.println(header + " Error occurred while trying to obtain message text from server. Only message tokens are available.");
                            }
                            printWriter.println(header + " Tokens     = " + message);
                        }
                    }
                }
                printWriter.println(header + " Stack trace follows");
                e.printStackTrace(printWriter);
                sqlca = e.getSqlca();
                if (sqlca != null) {
                    sqlca.returnTokensOnlyInMessageText(false);
                }
                e = e.getNextException();
            }
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printTrace(SQLException e, PrintWriter printWriter, String messageHeader, boolean returnTokensOnly) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            while (e != null) {
                String header;
                if (e instanceof DataTruncation) {
                    header = messageHeader + "[DataTruncation@" + Integer.toHexString(e.hashCode()) + "]";
                    printWriter.println(header + " java.sql.DataTruncation");
                } else if (e instanceof SQLWarning) {
                    header = messageHeader + "[SQLWarning@" + Integer.toHexString(e.hashCode()) + "]";
                    printWriter.println(header + " java.sql.SQLWarning");
                } else if (e instanceof BatchUpdateException) {
                    header = messageHeader + "[BatchUpdateException@" + Integer.toHexString(e.hashCode()) + "]";
                    printWriter.println(header + " java.sql.BatchUpdateException");
                } else {
                    header = messageHeader + "[SQLException@" + Integer.toHexString(e.hashCode()) + "]";
                    printWriter.println(header + " java.sql.SQLException");
                }
                printWriter.println(header + " SQL state  = " + e.getSQLState());
                printWriter.println(header + " Error code = " + String.valueOf(e.getErrorCode()));
                printWriter.println(header + " Message    = " + e.getMessage());
                if (e instanceof DataTruncation) {
                    printWriter.println(header + " Index         = " + ((DataTruncation)e).getIndex());
                    printWriter.println(header + " Parameter     = " + ((DataTruncation)e).getParameter());
                    printWriter.println(header + " Read          = " + ((DataTruncation)e).getRead());
                    printWriter.println(header + " Data size     = " + ((DataTruncation)e).getDataSize());
                    printWriter.println(header + " Transfer size = " + ((DataTruncation)e).getTransferSize());
                }
                if (e instanceof BatchUpdateException) {
                    printWriter.println(header + " Update counts = " + Utils.getStringFromInts(((BatchUpdateException)e).getUpdateCounts()));
                }
                printWriter.println(header + " Stack trace follows");
                e.printStackTrace(printWriter);
                e = e.getNextException();
            }
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printTrace(Sqlca sqlca, PrintWriter printWriter, String messageHeader) {
        String header = messageHeader + "[Sqlca@" + Integer.toHexString(sqlca.hashCode()) + "]";
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(header + " DERBY SQLCA from server");
            printWriter.println(header + " SqlCode        = " + sqlca.getSqlCode());
            printWriter.println(header + " SqlErrd        = " + sqlca.formatSqlErrd());
            printWriter.println(header + " SqlErrmc       = " + sqlca.getSqlErrmc());
            printWriter.println(header + " SqlErrp        = " + sqlca.getSqlErrp());
            printWriter.println(header + " SqlState       = " + sqlca.getSqlState());
            printWriter.println(header + " SqlWarn        = " + sqlca.getSqlWarn());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printTrace(Throwable e, PrintWriter printWriter, String messageHeader) {
        String header = messageHeader + "[Throwable@" + Integer.toHexString(e.hashCode()) + "]";
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(header + " " + e.getClass().getName());
            printWriter.println(header + " Message = " + e.getMessage());
            printWriter.println(header + " Stack trace follows");
            e.printStackTrace(printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printTrace(XAException e, PrintWriter printWriter, String messageHeader) {
        String header = messageHeader + "[XAException@" + Integer.toHexString(e.hashCode()) + "]";
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(header + " javax.transaction.xa.XAException");
            printWriter.println(header + " Message = " + e.getMessage());
            printWriter.println(header + " Stack trace follows");
            e.printStackTrace(printWriter);
        }
    }
}

