"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateStackCommandSnippet = CreateStackCommandSnippet;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _pricing_features = require("../../../../common/pricing_features");
var _aws_firehose = require("../../../../common/aws_firehose");
var _copy_to_clipboard_button = require("../shared/copy_to_clipboard_button");
var _download_template_callout = require("./download_template_callout");
var _utils = require("./utils");
var _use_pricing_feature = require("../shared/use_pricing_feature");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/firehose/create_stack_command_snippet.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CreateStackCommandSnippet({
  encodedApiKey,
  elasticsearchUrl,
  templateUrl,
  isCopyPrimaryAction,
  metricsEnabled = true
}) {
  const metricsOnboardingEnabled = (0, _use_pricing_feature.usePricingFeature)(_pricing_features.ObservabilityOnboardingPricingFeature.METRICS_ONBOARDING);
  const stackStatusAccordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'stackStatusAccordion'
  });
  const createStackCommand = (0, _utils.buildCreateStackCommand)({
    templateUrl,
    stackName: _aws_firehose.FIREHOSE_CLOUDFORMATION_STACK_NAME,
    streamName: _aws_firehose.FIREHOSE_STREAM_NAME,
    encodedApiKey,
    elasticsearchUrl,
    metricsEnabled
  });
  const stackStatusCommand = (0, _utils.buildStackStatusCommand)({
    stackName: _aws_firehose.FIREHOSE_CLOUDFORMATION_STACK_NAME
  });
  const awsCLIInstallGuideLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "observabilityOnboardingFirehosePanelAwsInstallGuideLink",
    href: "https://docs.aws.amazon.com/cli/latest/userguide/getting-started-install.html",
    external: true,
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.awsCLIInstallGuideLinkLabel', {
    defaultMessage: 'AWS CLI'
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, metricsOnboardingEnabled && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.firehosePanel.createFirehoseStreamDescription",
    defaultMessage: "Run the command bellow in your terminal where you have {awsCLIInstallGuideLink} configured. The command will create a CloudFormation stack from our template that includes a Firehose delivery, backup S3 bucket, CloudWatch subscription filter and metrics stream along with required IAM roles.",
    values: {
      awsCLIInstallGuideLink
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }), !metricsOnboardingEnabled && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.logsEssential.firehosePanel.createFirehoseStreamDescription",
    defaultMessage: "Run the command bellow in your terminal where you have {awsCLIInstallGuideLink} configured. The command will create a CloudFormation stack from our template that includes a Firehose delivery, backup S3 bucket and CloudWatch subscription filter along with required IAM roles.",
    values: {
      awsCLIInstallGuideLink
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_download_template_callout.DownloadTemplateCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "text",
    paddingSize: "m",
    fontSize: "m",
    "data-test-subj": "observabilityOnboardingFirehoseCreateStackCommand",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, createStackCommand), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_copy_to_clipboard_button.CopyToClipboardButton, {
    textToCopy: createStackCommand,
    fill: isCopyPrimaryAction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: stackStatusAccordionId,
    buttonContent: _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.stackStatusAccordionButtonLabel', {
      defaultMessage: 'Check status of the CloudFormation stack'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "text",
    paddingSize: "m",
    fontSize: "m",
    isCopyable: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, stackStatusCommand)));
}