"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInferenceConnectorInfo = void 0;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInferenceConnectorInfo = connector => {
  if (!connector) {
    return;
  }
  const inferenceConnector = (0, _inferenceCommon.connectorToInference)(connector);
  const modelFamily = (0, _inferenceCommon.getConnectorFamily)(inferenceConnector);
  const modelProvider = (0, _inferenceCommon.getConnectorProvider)(inferenceConnector);
  const modelId = (0, _inferenceCommon.getConnectorModel)(inferenceConnector);
  return {
    connectorId: inferenceConnector.connectorId,
    name: inferenceConnector.name,
    type: inferenceConnector.type,
    modelFamily,
    modelProvider,
    modelId
  };
};
exports.getInferenceConnectorInfo = getInferenceConnectorInfo;