"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenuItem = TopNavMenuItem;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _routerUtils = require("@kbn/router-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/navigation/public/top_nav_menu/top_nav_menu_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function TopNavMenuItem(props) {
  var _props$color, _props$fill, _props$fill2;
  function isDisabled() {
    const val = (0, _lodash.isFunction)(props.disableButton) ? props.disableButton() : props.disableButton;
    return val;
  }
  function getTooltip() {
    const val = (0, _lodash.isFunction)(props.tooltip) ? props.tooltip() : props.tooltip;
    return val;
  }
  function ButtonContainer() {
    const {
      euiTheme
    } = (0, _eui.useEuiTheme)();
    if (props.badge) {
      return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiBetaBadge, (0, _extends2.default)({
        css: (0, _react.css)`
              margin-right: ${euiTheme.size.s};
              vertical-align: middle;

              button:hover &,
              button:focus & {
                text-decoration: underline;
              }
              button:hover & {
                cursor: pointer;
              }
            `
      }, props.badge, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 11
        }
      })), (0, _lodash.upperFirst)(props.label || props.id));
    } else {
      return (0, _lodash.upperFirst)(props.label || props.id);
    }
  }
  function handleClick(event) {
    if (isDisabled()) return;
    props.run(event.currentTarget);
    if (props.isMobileMenu) {
      props.closePopover();
    }
  }
  const routerLinkProps = props.href ? (0, _routerUtils.getRouterLinkProps)({
    href: props.href,
    onClick: handleClick
  }) : {
    onClick: handleClick
  };
  const commonButtonProps = {
    id: props.htmlId,
    isDisabled: isDisabled(),
    isLoading: props.isLoading,
    iconType: props.iconType,
    iconSide: props.iconSide,
    'data-test-subj': props.testId,
    className: props.className,
    color: (_props$color = props.color) !== null && _props$color !== void 0 ? _props$color : 'primary',
    ...routerLinkProps
  };

  // If the item specified a href, then override the suppress the onClick
  // and make it become a regular link
  const overrideProps = props.target && props.href ? {
    onClick: undefined,
    href: props.href,
    target: props.target
  } : {};
  const btn = props.iconOnly && props.iconType && !props.isMobileMenu ? (
  /*#__PURE__*/
  // icon only buttons are not supported by EuiHeaderLink
  _react2.default.createElement(props.disableButton ? _react2.default.Fragment : _eui.EuiToolTip,
  // @ts-expect-error - EuiToolTip does not accept `key` prop, we pass to react Fragment
  {
    ...(props.disableButton ? {
      key: props.label || props.id
    } : {
      content: (0, _lodash.upperFirst)(props.label || props.id),
      position: 'bottom',
      delay: 'long'
    })
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    size: "s"
  }, (0, _lodash.omit)(commonButtonProps, 'iconSide'), {
    iconType: props.iconType,
    display: props.emphasize && ((_props$fill = props.fill) !== null && _props$fill !== void 0 ? _props$fill : true) ? 'fill' : undefined,
    "aria-label": (0, _lodash.upperFirst)(props.label || props.id),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  })))) : props.emphasize ?
  /*#__PURE__*/
  // fill is not compatible with EuiHeaderLink
  _react2.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    size: "s",
    fullWidth: props.isMobileMenu
  }, commonButtonProps, {
    fill: (_props$fill2 = props.fill) !== null && _props$fill2 !== void 0 ? _props$fill2 : true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(ButtonContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  })) : /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderLink, (0, _extends2.default)({
    size: "s"
  }, commonButtonProps, overrideProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(ButtonContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }));
  const tooltip = getTooltip();
  if (tooltip) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
      content: tooltip,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 12
      }
    }, btn);
  }
  return btn;
}
TopNavMenuItem.defaultProps = {
  disableButton: false,
  tooltip: ''
};