"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineViewer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _detail_drawer = require("./detail_drawer");
var _queue = require("./queue");
var _statement_section = require("./statement_section");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/logstash/pipeline_viewer/views/pipeline_viewer.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class PipelineViewer extends _react.default.Component {
  constructor() {
    super();
    (0, _defineProperty2.default)(this, "renderDetailDrawer", () => {
      if (!this.props.detailVertex) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_detail_drawer.DetailDrawer, {
        vertex: this.props.detailVertex,
        onHide: () => this.props.setDetailVertexId(undefined),
        timeseriesTooltipXValueFormatter: this.props.timeseriesTooltipXValueFormatter,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 33,
          columnNumber: 7
        }
      });
    });
    this.state = {
      detailDrawer: {
        vertex: null
      }
    };
  }
  render() {
    const {
      inputs,
      filters,
      outputs,
      queue
    } = this.props.pipeline;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logstash.pipeline_viewer.heading",
      defaultMessage: "Logstash pipelines",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      "data-test-subj": "pipeline-viewer",
      alignment: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_statement_section.StatementSection, {
      iconType: "logstashInput",
      headingText: _i18n.i18n.translate('xpack.monitoring.logstash.pipelineViewer.inputsTitle', {
        defaultMessage: 'Inputs'
      }),
      elements: inputs,
      onShowVertexDetails: this.props.setDetailVertexId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_queue.Queue, {
      queue: queue,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_statement_section.StatementSection, {
      iconType: "logstashFilter",
      headingText: _i18n.i18n.translate('xpack.monitoring.logstash.pipelineViewer.filtersTitle', {
        defaultMessage: 'Filters'
      }),
      elements: filters,
      onShowVertexDetails: this.props.setDetailVertexId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_statement_section.StatementSection, {
      iconType: "logstashOutput",
      headingText: _i18n.i18n.translate('xpack.monitoring.logstash.pipelineViewer.outputsTitle', {
        defaultMessage: 'Outputs'
      }),
      elements: outputs,
      onShowVertexDetails: this.props.setDetailVertexId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 13
      }
    }), this.renderDetailDrawer())));
  }
}
exports.PipelineViewer = PipelineViewer;
PipelineViewer.propTypes = {
  pipeline: _propTypes.default.shape({
    inputs: _propTypes.default.array.isRequired,
    filters: _propTypes.default.array.isRequired,
    outputs: _propTypes.default.array.isRequired,
    queue: _propTypes.default.object.isRequired
  }).isRequired
};