"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Reason = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _legacy_shims = require("../../legacy_shims");
var _monospace = require("../metricbeat_migration/instruction_steps/components/monospace/monospace");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/logs/reason.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Reason = ({
  reason
}) => {
  const filebeatUrl = _legacy_shims.Legacy.shims.docLinks.links.filebeat.installation;
  const elasticsearchUrl = _legacy_shims.Legacy.shims.docLinks.links.filebeat.elasticsearchModule;
  const troubleshootUrl = _legacy_shims.Legacy.shims.docLinks.links.monitoring.troubleshootKibana;
  let title = _i18n.i18n.translate('xpack.monitoring.logs.reason.defaultTitle', {
    defaultMessage: 'No log data found'
  });
  let message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logs.reason.defaultMessage",
    defaultMessage: "We did not find any log data and we are unable to diagnose why. {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: filebeatUrl,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.logs.reason.defaultMessageLink",
        defaultMessage: "Please verify your setup is correct.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 13
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  });
  if (false === (reason === null || reason === void 0 ? void 0 : reason.indexPatternExists)) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.noIndexPatternTitle', {
      defaultMessage: 'No log data found'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.noIndexPatternMessage",
      defaultMessage: "Set up {link}, then configure your Elasticsearch output to your monitoring cluster.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: filebeatUrl,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.noIndexPatternLink', {
          defaultMessage: 'Filebeat'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 7
      }
    });
  } else if (false === (reason === null || reason === void 0 ? void 0 : reason.indexPatternInTimeRangeExists) || false === (reason === null || reason === void 0 ? void 0 : reason.typeExists) && reason.typeExistsAtAnyTime) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.noIndexPatternInTimePeriodTitle', {
      defaultMessage: 'No logs for the selected time'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.noIndexPatternInTimePeriodMessage",
      defaultMessage: "Use the time filter to adjust your timeframe.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    });
  } else if (false === (reason === null || reason === void 0 ? void 0 : reason.typeExists)) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.noTypeTitle', {
      defaultMessage: 'No logs for Elasticsearch'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.noTypeMessage",
      defaultMessage: "Follow {link} to set up Elasticsearch.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: elasticsearchUrl,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 93,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.noTypeLink', {
          defaultMessage: 'these directions'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    });
  } else if (false === (reason === null || reason === void 0 ? void 0 : reason.usingStructuredLogs)) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.notUsingStructuredLogsTitle', {
      defaultMessage: 'No structured logs found'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.notUsingStructuredLogsMessage",
      defaultMessage: "Check if the {varPaths} setting {link}.",
      values: {
        varPaths: /*#__PURE__*/_react.default.createElement(_monospace.Monospace, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 111,
            columnNumber: 21
          }
        }, "var.paths"),
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: elasticsearchUrl,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.notUsingStructuredLogsLink', {
          defaultMessage: 'points to JSON logs'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 7
      }
    });
  } else if (false === (reason === null || reason === void 0 ? void 0 : reason.clusterExists)) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.noClusterTitle', {
      defaultMessage: 'No logs for this cluster'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.noClusterMessage",
      defaultMessage: "Check that your {link} is correct.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: elasticsearchUrl,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.noClusterLink', {
          defaultMessage: 'setup'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 7
      }
    });
  } else if (false === (reason === null || reason === void 0 ? void 0 : reason.nodeExists)) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.noNodeTitle', {
      defaultMessage: 'No logs for this Elasticsearch node'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.noNodeMessage",
      defaultMessage: "Check that your {link} is correct.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: elasticsearchUrl,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 151,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.noNodeLink', {
          defaultMessage: 'setup'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 7
      }
    });
  } else if (false === (reason === null || reason === void 0 ? void 0 : reason.indexExists)) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.noIndexTitle', {
      defaultMessage: 'No logs for this index'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.noIndexMessage",
      defaultMessage: "We found logs, but none for this index. If this problem continues, check that your {link} is correct.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: elasticsearchUrl,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 170,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.noIndexLink', {
          defaultMessage: 'setup'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 7
      }
    });
  } else if (false === (reason === null || reason === void 0 ? void 0 : reason.correctIndexName)) {
    title = _i18n.i18n.translate('xpack.monitoring.logs.reason.correctIndexNameTitle', {
      defaultMessage: 'Corrupted filebeat index'
    });
    message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.reason.correctIndexNameMessage",
      defaultMessage: "There is an issue reading from your filebeat indices.  {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          href: troubleshootUrl,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 189,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.monitoring.logs.reason.correctIndexNameLink', {
          defaultMessage: 'Click here for more information'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: title,
    color: "warning",
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }, message));
};
exports.Reason = Reason;