"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogstashPanel = LogstashPanel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _format_number = require("../../../lib/format_number");
var _helpers = require("./helpers");
var _constants = require("../../../../common/constants");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _tooltip = require("../../setup_mode/tooltip");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _badge = require("../../../alerts/badge");
var _should_show_alert_badge = require("../../../alerts/lib/should_show_alert_badge");
var _setup_mode = require("../../../lib/setup_mode");
var _enums = require("../../../../common/enums");
var _setup_mode_context = require("../../setup_mode/setup_mode_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/cluster/overview/logstash_panel.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NODES_PANEL_RULES = [_constants.RULE_LOGSTASH_VERSION_MISMATCH];
function LogstashPanel(props) {
  const {
    setupMode
  } = props;
  const nodesCount = props.node_count || 0;
  const queueTypes = props.queue_types || {};
  const alerts = props.alerts;
  const setupModeContext = _react.default.useContext(_setup_mode_context.SetupModeContext);

  // Do not show if we are not in setup mode
  if (!nodesCount && !setupMode.enabled) {
    return null;
  }
  const goToLogstash = () => (0, _get_safe_for_external_link.getSafeForExternalLink)('#/logstash');
  const goToNodes = () => (0, _get_safe_for_external_link.getSafeForExternalLink)('#/logstash/nodes');
  const goToPipelines = () => (0, _get_safe_for_external_link.getSafeForExternalLink)('#/logstash/pipelines');
  const setupModeData = (0, _lodash.get)(setupMode.data, 'logstash');
  const setupModeMetricbeatMigrationTooltip = (0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration) ? /*#__PURE__*/_react.default.createElement(_tooltip.SetupModeTooltip, {
    setupModeData: setupModeData,
    productName: _constants.LOGSTASH_SYSTEM_ID,
    badgeClickLink: goToNodes(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }) : null;
  let nodesAlertStatus = null;
  if ((0, _should_show_alert_badge.shouldShowAlertBadge)(alerts, NODES_PANEL_RULES, setupModeContext)) {
    const alertsList = NODES_PANEL_RULES.map(alertType => alerts[alertType]);
    nodesAlertStatus = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_badge.AlertsBadge, {
      alerts: alertsList,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_helpers.ClusterItemContainer, (0, _extends2.default)({}, props, {
    url: "logstash",
    title: _i18n.i18n.translate('xpack.monitoring.cluster.overview.logstashPanel.logstashTitle', {
      defaultMessage: 'Logstash'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 4,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.DisabledIfNoDataAndInSetupModeLink, {
    setupModeEnabled: setupMode.enabled,
    setupModeData: setupModeData,
    href: goToLogstash(),
    "data-test-subj": "lsOverview",
    "aria-label": _i18n.i18n.translate('xpack.monitoring.cluster.overview.logstashPanel.overviewLinkAriaLabel', {
      defaultMessage: 'Logstash Overview'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.logstashPanel.overviewLinkLabel",
    defaultMessage: "Overview",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    "data-test-subj": "logstash_overview",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.logstashPanel.eventsReceivedLabel",
    defaultMessage: "Events Received",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "lsEventsReceived",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 15
    }
  }, (0, _format_number.formatNumber)(props.events_in_total, '0.[0]a')), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.logstashPanel.eventsEmittedLabel",
    defaultMessage: "Events Emitted",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "lsEventsEmitted",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }, (0, _format_number.formatNumber)(props.events_out_total, '0.[0]a'))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: goToNodes(),
    "data-test-subj": "lsNodes",
    "aria-label": _i18n.i18n.translate('xpack.monitoring.cluster.overview.logstashPanel.nodesCountLinkAriaLabel', {
      defaultMessage: 'Logstash Nodes: {nodesCount}',
      values: {
        nodesCount
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.logstashPanel.nodesCountLinkLabel",
    defaultMessage: "Nodes: {nodesCount}",
    values: {
      nodesCount: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "number_of_logstash_instances",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 29
        }
      }, nodesCount)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 23
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 17
    }
  }, setupModeMetricbeatMigrationTooltip, nodesAlertStatus))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.logstashPanel.uptimeLabel",
    defaultMessage: "Uptime",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "lsUptime",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  }, props.max_uptime ? (0, _format_number.formatNumber)(props.max_uptime, 'time_since') : 0), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.logstashPanel.jvmHeapLabel",
    defaultMessage: "{javaVirtualMachine} Heap",
    values: {
      javaVirtualMachine: 'JVM'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "lsJvmHeap",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.BytesPercentageUsage, {
    usedBytes: props.avg_memory_used,
    maxBytes: props.avg_memory,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.DisabledIfNoDataAndInSetupModeLink, {
    setupModeEnabled: setupMode.enabled,
    setupModeData: setupModeData,
    href: goToPipelines(),
    "data-test-subj": "lsPipelines",
    "aria-label": _i18n.i18n.translate('xpack.monitoring.cluster.overview.logstashPanel.pipelineCountLinkAriaLabel', {
      defaultMessage: 'Logstash Pipelines: {pipelineCount}',
      values: {
        pipelineCount: props.pipeline_count
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.logstashPanel.pipelinesCountLinkLabel",
    defaultMessage: "Pipelines: {pipelineCount}",
    values: {
      pipelineCount: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "number_of_logstash_pipelines",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 29
        }
      }, props.pipeline_count)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 23
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.logstashPanel.withMemoryQueuesLabel",
    defaultMessage: "With Memory Queues",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 15
    }
  }, queueTypes[_constants.LOGSTASH.QUEUE_TYPES.MEMORY] || 0), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.logstashPanel.withPersistentQueuesLabel",
    defaultMessage: "With Persistent Queues",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 15
    }
  }, queueTypes[_constants.LOGSTASH.QUEUE_TYPES.PERSISTED] || 0))))));
}