"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _enums = require("../../common/enums");
var _badge = require("./badge");
var _setup_mode = require("../lib/setup_mode");
var _setup_mode_context = require("../components/setup_mode/setup_mode_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertsStatus = props => {
  const {
    alerts,
    showBadge = false,
    showOnlyCount = false,
    stateFilter = () => true
  } = props;
  const inSetupMode = (0, _setup_mode.isInSetupMode)(_react.default.useContext(_setup_mode_context.SetupModeContext));
  if (!alerts) {
    return null;
  }
  let atLeastOneDanger = false;
  const count = Object.values(alerts).flat().reduce((cnt, alertStatus) => {
    const firingStates = alertStatus.states.filter(state => state.firing);
    const firingAndFilterStates = firingStates.filter(state => stateFilter(state.state));
    cnt += firingAndFilterStates.length;
    if (firingStates.length) {
      if (!atLeastOneDanger) {
        for (const state of alertStatus.states) {
          if (stateFilter(state.state) && state.state.ui.severity === _enums.AlertSeverity.Danger) {
            atLeastOneDanger = true;
            break;
          }
        }
      }
    }
    return cnt;
  }, 0);
  if (count === 0 && (!inSetupMode || showOnlyCount)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.monitoring.alerts.status.clearToolip', {
        defaultMessage: 'No alerts firing'
      }),
      position: "bottom",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "success",
      "data-test-subj": "alertIcon",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 9
      }
    }, showOnlyCount ? count : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "alertStatusText",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.alerts.status.clearText",
      defaultMessage: "Clear",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 15
      }
    }))));
  }
  if (showBadge || inSetupMode) {
    return /*#__PURE__*/_react.default.createElement(_badge.AlertsBadge, {
      alerts: alerts,
      stateFilter: stateFilter,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 12
      }
    });
  }
  const severity = atLeastOneDanger ? _enums.AlertSeverity.Danger : _enums.AlertSeverity.Warning;
  const tooltipText = (() => {
    switch (severity) {
      case _enums.AlertSeverity.Danger:
        return _i18n.i18n.translate('xpack.monitoring.alerts.status.highSeverityTooltip', {
          defaultMessage: 'There are some critical issues that require your immediate attention!'
        });
      case _enums.AlertSeverity.Warning:
        return _i18n.i18n.translate('xpack.monitoring.alerts.status.mediumSeverityTooltip', {
          defaultMessage: 'There are some issues that might have impact on the stack.'
        });
      default:
        // might never show
        return _i18n.i18n.translate('xpack.monitoring.alerts.status.lowSeverityTooltip', {
          defaultMessage: 'There are some low-severity issues.'
        });
    }
  })();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipText,
    position: "bottom",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: severity,
    "data-test-subj": "alertIcon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, showOnlyCount ? count : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.alerts.status.alertsTooltip",
    defaultMessage: "Alerts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  })));
};
exports.AlertsStatus = AlertsStatus;