"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleWorker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _parser = require("../parser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/* eslint-disable-next-line @kbn/eslint/module_migration */

class ConsoleWorker {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "parser", void 0);
    (0, _defineProperty2.default)(this, "parserResult", void 0);
    this.ctx = ctx;
  }
  getParserResult(modelUri) {
    if (!this.parser) {
      this.parser = (0, _parser.createParser)();
    }
    const model = this.ctx.getMirrorModels().find(m => m.uri.toString() === modelUri);
    if (model) {
      this.parserResult = this.parser(model.getValue());
    }
    return this.parserResult;
  }
}
exports.ConsoleWorker = ConsoleWorker;