"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatMemoryUsageUrl = formatMemoryUsageUrl;
exports.formatTrainedModelsManagementUrl = formatTrainedModelsManagementUrl;
var _public = require("@kbn/kibana-utils-plugin/public");
var _locator = require("../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatTrainedModelsManagementUrl(appBasePath, mlUrlGeneratorState) {
  let url = `${appBasePath}`;
  if (mlUrlGeneratorState) {
    const {
      modelId
    } = mlUrlGeneratorState;
    if (modelId) {
      const modelsListState = {
        queryText: `model_id:(${modelId})`
      };
      const queryState = {
        [_locator.ML_PAGES.TRAINED_MODELS_MANAGE]: modelsListState
      };
      url = (0, _public.setStateToKbnUrl)('_a', queryState, {
        useHash: false,
        storeInHashQuery: false
      }, url);
    }
  }
  return url;
}
function formatMemoryUsageUrl(appBasePath, mlUrlGeneratorState) {
  let url = `${appBasePath}/${_locator.ML_PAGES.MEMORY_USAGE}`;
  if (mlUrlGeneratorState) {
    const {
      nodeId
    } = mlUrlGeneratorState;
    if (nodeId) {
      const nodesListState = {
        queryText: `name:(${nodeId})`
      };
      const queryState = {
        [_locator.ML_PAGES.MEMORY_USAGE]: nodesListState
      };
      url = (0, _public.setStateToKbnUrl)('_a', queryState, {
        useHash: false,
        storeInHashQuery: false
      }, url);
    }
  }
  return url;
}