"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFlyout = createFlyout;
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _get_services = require("../../../application/util/get_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/embeddables/job_creation/common/create_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function createFlyout(FlyoutComponent, coreStart, share, data, dashboardService, lens) {
  const {
    http,
    overlays,
    application: {
      currentAppId$
    },
    ...startServices
  } = coreStart;
  return new Promise(async (resolve, reject) => {
    try {
      const onFlyoutClose = () => {
        flyoutSession.close();
        resolve();
      };
      const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: {
          ...coreStart,
          share,
          data,
          lens,
          dashboardService,
          mlServices: (0, _get_services.getMlGlobalServices)(coreStart, data.dataViews)
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(FlyoutComponent, {
        onClose: () => {
          onFlyoutClose();
          resolve();
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 13
        }
      })), startServices), {
        'data-test-subj': 'mlFlyoutLayerSelector',
        'aria-labelledby': 'ml-flyout-layer-title',
        ownFocus: true,
        onClose: onFlyoutClose,
        size: '35vw'
      });

      // Close the flyout when user navigates out of the current plugin
      currentAppId$.pipe((0, _rxjs.skip)(1), (0, _rxjs.takeUntil)((0, _rxjs.from)(flyoutSession.onClose)), (0, _rxjs.distinctUntilChanged)()).subscribe(() => {
        flyoutSession.close();
      });
    } catch (error) {
      reject(error);
    }
  });
}